/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.XML;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.FileSystemUtil;
import ortus.boxlang.runtime.util.conversion.XMLValidationHandler;

@BoxBIF
public class XMLValidate
extends BIF {
    public XMLValidate() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.XML), new Argument(false, "string", Key.validator)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Object xmlObject = arguments.get(Key.XML);
        String validator = arguments.getAsString(Key.validator);
        String xmlString = null;
        Struct response = new Struct((Map<? extends Object, ? extends Object>)new HashMap<Key, Object>(){
            {
                this.put(Key.errors, new Array());
                this.put(Key.fatalErrors, new Array());
                this.put(Key.status, true);
                this.put(Key.warning, new Array());
            }
        });
        XMLValidationHandler errorHandler = new XMLValidationHandler(response);
        xmlString = xmlObject instanceof XML ? xmlObject.toString() : (StringUtils.equals(StringCaster.cast(xmlObject).substring(0, 3), "http") ? StringCaster.cast(FileSystemUtil.read(StringCaster.cast(xmlObject))) : StringCaster.cast(xmlObject));
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlString.getBytes());
        StreamSource xmlStreamSource = new StreamSource(xmlInputStream);
        Schema schema = null;
        try {
            if (validator == null) {
                factory = SchemaFactory.newInstance("http://www.w3.org/TR/REC-xml");
                schema = factory.newSchema();
            } else {
                factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                if (StringUtils.equals(validator.substring(0, 3), "http")) {
                    try {
                        schema = factory.newSchema(new URI(validator).toURL());
                    }
                    catch (URISyntaxException u) {
                        throw new BoxRuntimeException(String.format("The valdator argument, [%s], is not a valid URI", validator), u);
                    }
                } else {
                    schema = factory.newSchema(new SAXSource(new InputSource(new ByteArrayInputStream(validator.getBytes()))));
                }
            }
            Validator schemaValidator = schema.newValidator();
            schemaValidator.setErrorHandler(errorHandler);
            schemaValidator.validate(xmlStreamSource);
        }
        catch (IOException | SAXException e) {
            response.put(Key.status, (Object)false);
            ArrayCaster.cast(response.get(Key.fatalErrors)).push(e.getMessage());
        }
        return response;
    }
}

