/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.zip;

import java.util.Set;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.util.ZipUtil;
import ortus.boxlang.runtime.validation.Validator;

@BoxBIF
public class Compress
extends BIF {
    public Compress() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.format, Set.of(Validator.valueOneOf("zip", "gzip"))), new Argument(true, "string", Key.source), new Argument(true, "string", Key.destination), new Argument(false, "boolean", Key.includeBaseFolder, true), new Argument(false, "boolean", Key.overwrite, false), new Argument(false, "string", Key.prefix, Set.of(Validator.NON_EMPTY)), new Argument(false, "any", Key.filter), new Argument(false, "boolean", Key.recurse, true)};
    }

    @Override
    public String _invoke(IBoxContext context, ArgumentsScope arguments) {
        String format = arguments.getAsString(Key.format);
        String source = arguments.getAsString(Key.source);
        String destination = arguments.getAsString(Key.destination);
        boolean includeBaseFolder = BooleanCaster.cast(arguments.get(Key.includeBaseFolder));
        boolean overwrite = BooleanCaster.cast(arguments.get(Key.overwrite));
        Object prefix = arguments.get(Key.prefix);
        Object filter = arguments.get(Key.filter);
        return ZipUtil.compress(ZipUtil.COMPRESSION_FORMAT.valueOf(format.toUpperCase()), source, destination, includeBaseFolder, overwrite, prefix == null ? "" : StringCaster.cast(prefix), filter, BooleanCaster.cast(arguments.get(Key.recurse)), context);
    }
}

