/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.zip;

import java.util.Set;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.util.ZipUtil;
import ortus.boxlang.runtime.validation.Validator;

@BoxBIF
public class Extract
extends BIF {
    public Extract() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.format, Set.of(Validator.valueOneOf("zip", "gzip"))), new Argument(true, "string", Key.source), new Argument(true, "string", Key.destination), new Argument(false, "boolean", Key.overwrite, false), new Argument(false, "boolean", Key.recurse, true), new Argument(false, "any", Key.filter), new Argument(false, "any", Key.entryPaths)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String format = arguments.getAsString(Key.format);
        String source = arguments.getAsString(Key.source);
        String destination = arguments.getAsString(Key.destination);
        Boolean overwrite = BooleanCaster.cast(arguments.get(Key.overwrite));
        Boolean recurse = BooleanCaster.cast(arguments.get(Key.recurse));
        Array entryPaths = new Array();
        Object entryPathsValue = arguments.get(Key.entryPaths);
        if (entryPathsValue != null) {
            if (entryPathsValue instanceof String) {
                entryPaths.add(entryPathsValue);
            } else if (entryPathsValue instanceof Array) {
                entryPaths = (Array)entryPathsValue;
            }
        }
        ZipUtil.extract(ZipUtil.COMPRESSION_FORMAT.valueOf(format.toUpperCase()), source, destination, overwrite, recurse, arguments.get(Key.filter), entryPaths, context);
        return null;
    }
}

