/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.cache;

import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import ortus.boxlang.runtime.cache.ICacheEntry;
import ortus.boxlang.runtime.dynamic.Attempt;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;

public class BoxCacheEntry
implements ICacheEntry {
    public static final ICacheEntry EMPTY = new BoxCacheEntry(Key._EMPTY, 0L, 0L, Key._EMPTY, null, new Struct());
    private static final long serialVersionUID = 1L;
    private Key cacheName;
    private AtomicLong hits = new AtomicLong(0L);
    private long timeout;
    private long lastAccessTimeout;
    private Instant created = Instant.now();
    private Instant lastAccessed = Instant.now();
    private Key key;
    private Object value;
    private IStruct metadata = new Struct();
    private int hashCode;

    public BoxCacheEntry(Key cacheName, long timeout, long lastAccessTimeout, Key key, Object value, IStruct metadata) {
        this.cacheName = cacheName;
        this.timeout = timeout;
        this.lastAccessTimeout = lastAccessTimeout;
        this.key = key;
        this.value = value;
        this.metadata = metadata;
        int prime = 31;
        this.hashCode = 1;
        this.hashCode = 31 * this.hashCode + key.hashCode();
        this.hashCode = 31 * this.hashCode + cacheName.hashCode();
        this.hashCode = 31 * this.hashCode + Long.hashCode(timeout);
        this.hashCode = 31 * this.hashCode + Long.hashCode(lastAccessTimeout);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoxCacheEntry other = (BoxCacheEntry)obj;
        return other.hashCode() == this.hashCode();
    }

    @Override
    public ICacheEntry setValue(Object value) {
        this.value = value;
        return this;
    }

    @Override
    public ICacheEntry setMetadata(Struct metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public ICacheEntry touchLastAccessed() {
        this.lastAccessed = Instant.now();
        return this;
    }

    @Override
    public ICacheEntry resetCreated() {
        this.created = Instant.now();
        return this;
    }

    @Override
    public ICacheEntry incrementHits() {
        this.hits.incrementAndGet();
        return this;
    }

    @Override
    public Key cacheName() {
        return this.cacheName;
    }

    @Override
    public long hits() {
        return this.hits.get();
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    @Override
    public long lastAccessTimeout() {
        return this.lastAccessTimeout;
    }

    @Override
    public Instant created() {
        return this.created;
    }

    @Override
    public Instant lastAccessed() {
        return this.lastAccessed;
    }

    @Override
    public boolean isEternal() {
        return this.timeout == 0L;
    }

    @Override
    public Key key() {
        return this.key;
    }

    @Override
    public Attempt<Object> value() {
        return Attempt.of(this.value);
    }

    @Override
    public Object rawValue() {
        return this.value;
    }

    @Override
    public IStruct metadata() {
        return this.metadata;
    }

    @Override
    public IStruct toStruct() {
        return Struct.of(new Object[]{"cacheName", this.cacheName, "hits", this.hits.get(), "timeout", this.timeout, "lastAccessTimeout", this.lastAccessTimeout, "created", this.created, "lastAccessed", this.lastAccessed, "key", this.key, "metadata", this.metadata, "isEternal", this.isEternal()});
    }

    public IStruct getMemento() {
        IStruct results = this.toStruct();
        results.put("value", this.value);
        return results;
    }
}

