/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.cache.filters;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ortus.boxlang.runtime.cache.filters.ICacheKeyFilter;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;

public class RegexFilter
implements ICacheKeyFilter {
    protected final Pattern regexPattern;

    public RegexFilter(String regex) {
        this(regex, true);
    }

    public RegexFilter(String regex, boolean ignoreCase) {
        try {
            this.regexPattern = Pattern.compile(regex, ignoreCase ? 2 : 0);
        }
        catch (PatternSyntaxException e) {
            throw new BoxValidationException("Invalid regex: " + regex, e);
        }
    }

    @Override
    public boolean test(Key input) {
        return this.regexPattern.matcher(input.getName()).matches();
    }
}

