/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.cache.filters;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ortus.boxlang.runtime.cache.filters.ICacheKeyFilter;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;

public class WildcardFilter
implements ICacheKeyFilter {
    protected final Pattern regexPattern;
    private static final String SPECIALS = "{}[]().+\\^$";

    public WildcardFilter(String wildcard) {
        this(wildcard, true);
    }

    public WildcardFilter(String wildcard, boolean ignoreCase) {
        String regex = wildcard;
        for (char c : SPECIALS.toCharArray()) {
            regex = regex.replace(String.valueOf(c), "\\" + c);
        }
        regex = regex.replace("?", ".").replace("**", "*").replace("*", ".*").replace("[!", "[^");
        try {
            this.regexPattern = Pattern.compile(regex, ignoreCase ? 2 : 0);
        }
        catch (PatternSyntaxException e) {
            throw new BoxValidationException("Invalid wildcard: " + wildcard, e);
        }
    }

    @Override
    public boolean test(Key input) {
        return this.regexPattern.matcher(input.toString()).matches();
    }
}

