/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.cache.providers;

import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import ortus.boxlang.runtime.async.executors.ExecutorRecord;
import ortus.boxlang.runtime.cache.providers.ICacheProvider;
import ortus.boxlang.runtime.cache.store.IObjectStore;
import ortus.boxlang.runtime.cache.store.ObjectStoreType;
import ortus.boxlang.runtime.cache.util.BoxCacheStats;
import ortus.boxlang.runtime.cache.util.ICacheStats;
import ortus.boxlang.runtime.config.segments.CacheConfig;
import ortus.boxlang.runtime.dynamic.Attempt;
import ortus.boxlang.runtime.dynamic.casters.LongCaster;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.events.InterceptorPool;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.CacheService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public abstract class AbstractCacheProvider
implements ICacheProvider {
    public static final Class<ObjectStoreType> TYPES = ObjectStoreType.class;
    protected Key name;
    protected AtomicBoolean enabled = new AtomicBoolean(false);
    protected boolean reportingEnabled = false;
    protected ICacheStats stats;
    protected CacheConfig config;
    protected CacheService cacheService;
    protected InterceptorPool interceptorPool;

    @Override
    public CacheService getCacheService() {
        return this.cacheService;
    }

    @Override
    public ICacheStats getStats() {
        return this.stats;
    }

    @Override
    public InterceptorPool getInterceptorPool() {
        return this.interceptorPool;
    }

    @Override
    public ICacheProvider clearStats() {
        this.stats.reset();
        return this;
    }

    @Override
    public Key getName() {
        return this.name;
    }

    public ICacheProvider setName(String name) {
        return this.setName(Key.of(name));
    }

    @Override
    public ICacheProvider setName(Key name) {
        this.name = name;
        return this;
    }

    @Override
    public String getType() {
        return this.config.provider.getName();
    }

    @Override
    public CacheConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    @Override
    public boolean isReportingEnabled() {
        return this.reportingEnabled;
    }

    @Override
    public IStruct getCachedObjectMetadata(String ... key) {
        Struct results = new Struct();
        for (String k : key) {
            results.put(k, (Object)this.getCachedObjectMetadata(k));
        }
        return results;
    }

    @Override
    public ICacheProvider configure(CacheService cacheService, CacheConfig config) {
        this.cacheService = cacheService;
        this.config = config;
        this.name = config.name;
        this.stats = new BoxCacheStats();
        this.interceptorPool = new InterceptorPool(this.name, cacheService.getRuntime()).registerInterceptionPoint(BoxEvent.toArray());
        return this;
    }

    @Override
    public CompletableFuture<Attempt<Object>> getAsync(String key) {
        return CompletableFuture.supplyAsync(() -> this.get(key), this.getTaskScheduler().executor());
    }

    protected ExecutorRecord getTaskScheduler() {
        return this.cacheService.getTaskScheduler();
    }

    protected boolean memoryThresholdCheck() {
        Integer threshold = this.config.properties.getAsInteger(Key.freeMemoryPercentageThreshold);
        if (threshold == 0) {
            return false;
        }
        long jvmThreshold = Runtime.getRuntime().freeMemory() / Runtime.getRuntime().maxMemory() * 100L;
        return (long)threshold.intValue() < jvmThreshold;
    }

    protected void announce(Key event, IStruct data) {
        this.interceptorPool.announce(event, data);
        this.cacheService.announce(event, data);
    }

    public void announce(BoxEvent state, IStruct data) {
        this.interceptorPool.announce(state.key(), data);
        this.cacheService.announce(state.key(), data);
    }

    public static Duration toDuration(Object timeout) {
        if (timeout instanceof Duration) {
            return (Duration)timeout;
        }
        return Duration.ofSeconds(LongCaster.cast(timeout));
    }

    protected static IObjectStore buildObjectStore(CacheConfig config) {
        String thisStore = config.properties.getAsString(Key.objectStore);
        if (thisStore instanceof IObjectStore) {
            IObjectStore castedStore = (IObjectStore)((Object)thisStore);
            return castedStore;
        }
        if (thisStore instanceof String) {
            String castedStore = thisStore;
            if (ObjectStoreType.isCore(Key.of(castedStore))) {
                return ObjectStoreType.getValueByKey(Key.of(castedStore)).buildStore();
            }
            return AbstractCacheProvider.buildObjectStoreByClass(castedStore);
        }
        throw new BoxRuntimeException("The object store is not a valid type [" + thisStore.getClass().getName() + "] Valid types are: " + String.valueOf(ObjectStoreType.values()));
    }

    protected static IObjectStore buildObjectStoreByClass(String storeClasspath) {
        try {
            Class<?> clazz = Class.forName(storeClasspath);
            if (IObjectStore.class.isAssignableFrom(clazz)) {
                try {
                    return (IObjectStore)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new BoxRuntimeException("Cannot call the constructor on the object store: " + storeClasspath, e);
                }
            }
            throw new BoxRuntimeException("The object does not implement IObjectStore: " + storeClasspath);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new BoxRuntimeException("Unable to load the custom object store: " + storeClasspath, e);
        }
    }
}

