/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.cache.providers;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.cache.BoxCacheEntry;
import ortus.boxlang.runtime.cache.ICacheEntry;
import ortus.boxlang.runtime.cache.filters.ICacheKeyFilter;
import ortus.boxlang.runtime.cache.providers.AbstractCacheProvider;
import ortus.boxlang.runtime.cache.providers.ICacheProvider;
import ortus.boxlang.runtime.cache.store.IObjectStore;
import ortus.boxlang.runtime.config.segments.CacheConfig;
import ortus.boxlang.runtime.dynamic.Attempt;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.CacheService;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.util.BLCollector;

public class BoxCacheProvider
extends AbstractCacheProvider {
    private static final Logger logger = LoggerFactory.getLogger(BoxCacheProvider.class);
    private IObjectStore objectStore;
    private ScheduledFuture<?> reapingFuture;
    private Duration defaultTimeout;
    private Duration defaultLastAccessTimeout;
    private int maxObjects;

    @Override
    public synchronized ICacheProvider configure(CacheService cacheService, CacheConfig config) {
        super.configure(cacheService, config);
        logger.debug("Starting up BoxCache [{}].", (Object)this.getName().getName());
        this.objectStore = BoxCacheProvider.buildObjectStore(config).init(this, config.properties);
        this.reportingEnabled = true;
        this.maxObjects = config.properties.getAsInteger(Key.maxObjects);
        this.defaultTimeout = Duration.ofSeconds(config.properties.getAsInteger(Key.defaultTimeout).longValue());
        this.defaultLastAccessTimeout = Duration.ofSeconds(config.properties.getAsInteger(Key.defaultLastAccessTimeout).longValue());
        Long frequency = config.properties.getAsInteger(Key.reapFrequency).longValue();
        this.reapingFuture = this.cacheService.getTaskScheduler().newTask("boxcache-reaper-" + this.getName().getName()).delay(frequency, TimeUnit.SECONDS).spacedDelay(frequency, TimeUnit.SECONDS).call(this::reap).start();
        this.enabled.set(true);
        logger.debug("BoxCache [{}] has been initialized and ready for operation", (Object)this.getName().getName());
        return this;
    }

    @Override
    public IObjectStore getObjectStore() {
        return this.objectStore;
    }

    @Override
    public void shutdown() {
        this.objectStore.shutdown();
        logger.debug("BoxCache [{}] has been shutdown", (Object)this.getName().getName());
    }

    @Override
    public IStruct getStoreMetadataReport(int limit) {
        Struct report = new Struct();
        this.objectStore.getKeysStream().limit(limit).forEach(key -> {
            ICacheEntry results = this.objectStore.getQuiet((Key)key);
            report.put((Key)key, (Object)(results != null ? results.toStruct() : new Struct()));
        });
        return report;
    }

    @Override
    public IStruct getStoreMetadataReport() {
        return this.getStoreMetadataReport(Integer.MAX_VALUE);
    }

    @Override
    public IStruct getStoreMetadataKeyMap() {
        return Struct.of(new Object[]{"cacheName", "cacheName", "hits", "hits", "timeout", "timeout", "lastAccessTimeout", "lastAccessTimeout", "created", "created", "lastAccessed", "lastAccessed", "metadata", "metadata", "key", "key", "isEternal", "isEternal"});
    }

    @Override
    public IStruct getCachedObjectMetadata(String key) {
        ICacheEntry results = this.objectStore.get(Key.of(key));
        return results != null ? results.toStruct() : new Struct();
    }

    @Override
    public synchronized void reap() {
        long start = System.currentTimeMillis();
        Instant rightNow = Instant.now();
        this.objectStore.getKeysStream().map(this.objectStore::getQuiet).filter(Objects::nonNull).filter(entry -> !entry.isEternal()).forEach(entry -> {
            if (entry.created().plusSeconds(entry.timeout()).isBefore(rightNow)) {
                this.clear(entry.key().getName());
                return;
            }
            if (this.config.properties.getAsBoolean(Key.useLastAccessTimeouts).booleanValue() && entry.lastAccessTimeout() > 0L && entry.lastAccessed().plusSeconds(entry.lastAccessTimeout()).isBefore(rightNow)) {
                this.clear(entry.key().getName());
            }
        });
        this.getStats().recordReap();
        logger.debug("Finished reaping BoxCache [{}] in [{}]ms", (Object)this.getName().getName(), (Object)(System.currentTimeMillis() - start));
    }

    @Override
    public int getSize() {
        return this.objectStore.getSize();
    }

    public int getSize(ICacheKeyFilter filter) {
        return (int)this.objectStore.getKeysStream(filter).count();
    }

    @Override
    public void clearAll() {
        this.objectStore.clearAll();
        this.announce(BoxEvent.AFTER_CACHE_CLEAR_ALL, Struct.of(new Object[]{"cache", this}));
    }

    @Override
    public boolean clearAll(ICacheKeyFilter filter) {
        boolean results = this.objectStore.clearAll(filter);
        this.announce(BoxEvent.AFTER_CACHE_CLEAR_ALL, Struct.of(new Object[]{"cache", this, "filter", filter}));
        return results;
    }

    @Override
    public boolean clearQuiet(String key) {
        return this.objectStore.clear(Key.of(key));
    }

    @Override
    public boolean clear(String key) {
        this.announce(BoxEvent.BEFORE_CACHE_ELEMENT_REMOVED, Struct.of(new Object[]{"cache", this, "key", key}));
        boolean cleared = this.clearQuiet(key);
        this.announce(BoxEvent.AFTER_CACHE_ELEMENT_REMOVED, Struct.of(new Object[]{"cache", this, "key", key, "cleared", cleared}));
        return cleared;
    }

    @Override
    public IStruct clear(String ... keys) {
        Struct cleared = new Struct();
        for (String key : keys) {
            cleared.put(key, (Object)this.clear(key));
        }
        return cleared;
    }

    @Override
    public Array getKeys() {
        return this.objectStore.getKeysStream().map(Key::getName).collect(BLCollector.toArray());
    }

    @Override
    public Array getKeys(ICacheKeyFilter filter) {
        return this.objectStore.getKeysStream().filter(filter).map(Key::getName).collect(BLCollector.toArray());
    }

    @Override
    public Stream<String> getKeysStream() {
        return this.objectStore.getKeysStream().map(Key::getName);
    }

    @Override
    public Stream<String> getKeysStream(ICacheKeyFilter filter) {
        return this.objectStore.getKeysStream().filter(filter).map(Key::getName);
    }

    @Override
    public boolean lookupQuiet(String key) {
        return this.objectStore.lookup(Key.of(key));
    }

    @Override
    public boolean lookup(String key) {
        boolean found = this.lookupQuiet(key);
        if (found) {
            this.stats.recordHit();
        } else {
            this.stats.recordMiss();
        }
        return found;
    }

    @Override
    public IStruct lookup(String ... keys) {
        Struct found = new Struct();
        for (String key : keys) {
            found.put(key, (Object)this.lookup(key));
        }
        return found;
    }

    @Override
    public IStruct lookup(ICacheKeyFilter filter) {
        Struct found = new Struct();
        this.objectStore.getKeysStream().filter(filter).forEach(key -> found.put(key.getName(), (Object)this.lookup(key.getName())));
        return found;
    }

    @Override
    public Attempt<Object> getQuiet(String key) {
        ICacheEntry results = this.objectStore.get(Key.of(key));
        return results != null ? results.value() : Attempt.empty();
    }

    @Override
    public Attempt<Object> get(String key) {
        Attempt<Object> results = this.getQuiet(key);
        if (results.isPresent()) {
            this.stats.recordHit();
        } else {
            this.stats.recordMiss();
        }
        this.getTaskScheduler().submit(this::evictChecks);
        return results;
    }

    @Override
    public IStruct get(String ... keys) {
        Struct results = new Struct();
        for (String key : keys) {
            results.put(key, (Object)this.get(key));
        }
        return results;
    }

    @Override
    public IStruct get(ICacheKeyFilter filter) {
        Struct results = new Struct();
        this.objectStore.getKeysStream().filter(filter).forEach(key -> results.put(key.getName(), (Object)this.get(key.getName())));
        return results;
    }

    @Override
    public void setQuiet(Key key, ICacheEntry value) {
        this.objectStore.set(key, value);
    }

    @Override
    public void set(String key, Object value, Object timeout, Object lastAccessTimeout, IStruct metadata) {
        Attempt<Object> oldEntry = this.getQuiet(key);
        Duration dTimeout = BoxCacheProvider.toDuration(timeout);
        Duration dlastAccessTimeout = BoxCacheProvider.toDuration(lastAccessTimeout);
        Key boxKey = Key.of(key);
        BoxCacheEntry newEntry = new BoxCacheEntry(this.getName(), dTimeout.toSeconds(), dlastAccessTimeout.toSeconds(), boxKey, value, metadata);
        this.getTaskScheduler().submit(this::evictChecks);
        this.setQuiet(boxKey, newEntry);
        if (oldEntry.isPresent()) {
            this.announce(BoxEvent.AFTER_CACHE_ELEMENT_UPDATED, Struct.of(new Object[]{"cache", this, "key", boxKey, "oldEntry", oldEntry, "newEntry", newEntry}));
        } else {
            this.announce(BoxEvent.AFTER_CACHE_ELEMENT_INSERT, Struct.of(new Object[]{"cache", this, "key", boxKey, "entry", newEntry}));
        }
    }

    @Override
    public void set(String key, Object value, Object timeout, Object lastAccessTimeout) {
        this.set(key, value, timeout, lastAccessTimeout, new Struct());
    }

    @Override
    public void set(String key, Object value, Object timeout) {
        Duration lastAccessTimeout = this.defaultLastAccessTimeout;
        this.set(key, value, timeout, lastAccessTimeout, new Struct());
    }

    @Override
    public void set(String key, Object value) {
        Duration timeout = this.defaultTimeout;
        Duration lastAccessTimeout = this.defaultLastAccessTimeout;
        this.set(key, value, timeout, lastAccessTimeout);
    }

    @Override
    public void set(IStruct entries) {
        Duration timeout = this.defaultTimeout;
        Duration lastAccessTimeout = this.defaultLastAccessTimeout;
        entries.forEach((key, value) -> this.set(key.getName(), value, timeout, lastAccessTimeout));
    }

    @Override
    public void set(IStruct entries, Object timeout, Object lastAccessTimeout) {
        entries.forEach((key, value) -> this.set(key.getName(), value, timeout, lastAccessTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getOrSet(String key, Supplier<Object> provider, Object timeout, Object lastAccessTimeout, IStruct metadata) {
        Attempt<Object> results = this.get(key);
        if (results.isPresent()) {
            return results.get();
        }
        Duration dTimeout = BoxCacheProvider.toDuration(timeout);
        Duration dlastAccessTimeout = BoxCacheProvider.toDuration(lastAccessTimeout);
        String lockKey = this.getName().getNameNoCase() + "-" + key;
        String string = lockKey.intern();
        synchronized (string) {
            return this.get(key).orElseGet(() -> {
                Object value = provider.get();
                this.set(key, value, dTimeout, dlastAccessTimeout, metadata);
                return value;
            });
        }
    }

    @Override
    public Object getOrSet(String key, Supplier<Object> provider, Object timeout, Object lastAccessTimeout) {
        return this.getOrSet(key, provider, timeout, lastAccessTimeout, new Struct());
    }

    @Override
    public Object getOrSet(String key, Supplier<Object> provider, Object timeout) {
        Duration lastAccessTimeout = this.defaultLastAccessTimeout;
        return this.getOrSet(key, provider, timeout, lastAccessTimeout);
    }

    @Override
    public Object getOrSet(String key, Supplier<Object> provider) {
        Duration timeout = this.defaultTimeout;
        Duration lastAccessTimeout = this.defaultLastAccessTimeout;
        return this.getOrSet(key, provider, timeout, lastAccessTimeout);
    }

    public ScheduledFuture<?> getReapingFuture() {
        return this.reapingFuture;
    }

    private void evictChecks() {
        Boolean runEvict = false;
        if (this.memoryThresholdCheck()) {
            runEvict = true;
        }
        if (this.getSize() >= this.maxObjects) {
            runEvict = true;
        }
        if (runEvict.booleanValue()) {
            this.objectStore.evict();
        }
    }
}

