/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.cache.providers;

import ortus.boxlang.runtime.cache.providers.BoxCacheProvider;
import ortus.boxlang.runtime.cache.providers.ICacheProvider;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public enum CoreProviderType {
    BOXCACHE(Key.boxCacheProvider);

    private final Key key;

    private CoreProviderType(Key name) {
        this.key = name;
    }

    public Key getKey() {
        return this.key;
    }

    public static CoreProviderType getValueByKey(Key key) {
        for (CoreProviderType value : CoreProviderType.values()) {
            if (!value.getKey().equals(key)) continue;
            return value;
        }
        throw new BoxRuntimeException("No Core Provider " + CoreProviderType.class.getCanonicalName() + " with key " + String.valueOf(key));
    }

    public ICacheProvider buildProvider() {
        switch (this.ordinal()) {
            case 0: {
                return new BoxCacheProvider();
            }
        }
        throw new BoxRuntimeException("No Core Provider " + CoreProviderType.class.getCanonicalName());
    }

    public static boolean isCore(Key key) {
        for (CoreProviderType value : CoreProviderType.values()) {
            if (!value.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }
}

