/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.cache.store;

import java.lang.reflect.InvocationTargetException;
import ortus.boxlang.runtime.cache.policies.ICachePolicy;
import ortus.boxlang.runtime.cache.providers.ICacheProvider;
import ortus.boxlang.runtime.cache.store.IObjectStore;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public abstract class AbstractStore
implements IObjectStore {
    private static final String POLICIES_PACKAGE = "ortus.boxlang.runtime.cache.policies";
    private static final String VALID_POLICIES = "LRU|MRU|LFU|MFU|FIFO|LIFO|Random";
    protected ICacheProvider provider;
    protected IStruct config;
    private ICachePolicy policy;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public IStruct getConfig() {
        return this.config;
    }

    @Override
    public ICacheProvider getProvider() {
        return this.provider;
    }

    public ICachePolicy getPolicy() {
        if (this.policy == null) {
            this.policy = this.buildPolicy();
        }
        return this.policy;
    }

    private synchronized ICachePolicy buildPolicy() {
        Object thisPolicy = this.config.get(Key.evictionPolicy);
        if (thisPolicy instanceof ICachePolicy) {
            ICachePolicy castedPolicy = (ICachePolicy)thisPolicy;
            return castedPolicy;
        }
        if (thisPolicy instanceof String) {
            String castedPolicy = (String)thisPolicy;
            if (!castedPolicy.matches(VALID_POLICIES)) {
                throw new BoxRuntimeException("The eviction policy is not a valid policy." + this.policy.toString());
            }
            return this.buildPolicyByName(castedPolicy);
        }
        throw new BoxRuntimeException("The eviction policy is not a valid policy." + this.policy.toString());
    }

    protected ICachePolicy buildPolicyByName(String policyName) {
        String targetPolicy = "ortus.boxlang.runtime.cache.policies." + policyName;
        try {
            Class<?> clazz = Class.forName(targetPolicy);
            if (ICachePolicy.class.isAssignableFrom(clazz)) {
                try {
                    return (ICachePolicy)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new BoxRuntimeException("Cannot call the constructor on the policy: " + targetPolicy, e);
                }
            }
            throw new BoxRuntimeException("The policy does not implement ICachePolicy: " + targetPolicy);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new BoxRuntimeException("Unable to load the policy: " + targetPolicy, e);
        }
    }
}

