/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.cache.store;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.cache.ICacheEntry;
import ortus.boxlang.runtime.cache.filters.ICacheKeyFilter;
import ortus.boxlang.runtime.cache.providers.ICacheProvider;
import ortus.boxlang.runtime.cache.store.AbstractStore;
import ortus.boxlang.runtime.cache.store.IObjectStore;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;

public class ConcurrentSoftReferenceStore
extends AbstractStore {
    private static final Logger logger = LoggerFactory.getLogger(ConcurrentSoftReferenceStore.class);
    private ConcurrentHashMap<Key, SoftReference<ICacheEntry>> pool;
    private ConcurrentHashMap<Integer, Key> softRefKeyMap;
    private ReferenceQueue<ICacheEntry> referenceQueue;

    @Override
    public IObjectStore init(ICacheProvider provider, IStruct config) {
        this.provider = provider;
        this.config = config;
        this.pool = new ConcurrentHashMap(config.getAsInteger(Key.maxObjects) / 4);
        this.softRefKeyMap = new ConcurrentHashMap(config.getAsInteger(Key.maxObjects) / 4);
        this.referenceQueue = new ReferenceQueue();
        logger.debug("ConcurrentSoftReferenceStore({}) initialized with a max size of {}", (Object)provider.getName(), (Object)config.getAsInteger(Key.maxObjects));
        return this;
    }

    public ConcurrentMap<Key, SoftReference<ICacheEntry>> getPool() {
        return this.pool;
    }

    @Override
    public void shutdown() {
        this.getPool().clear();
        logger.debug("ConcurrentSoftReferenceStore({}) was shutdown", (Object)this.provider.getName());
    }

    @Override
    public int flush() {
        logger.debug("ConcurrentSoftReferenceStore({}) was flushed", (Object)this.provider.getName());
        return 0;
    }

    @Override
    public synchronized void evict() {
        if (this.config.getAsInteger(Key.evictCount) == 0) {
            return;
        }
        this.getPool().entrySet().parallelStream().map(reference -> (ICacheEntry)((SoftReference)reference.getValue()).get()).filter(entry -> entry != null && !entry.isEternal()).sorted(this.getPolicy().getComparator()).limit(this.config.getAsInteger(Key.evictCount).intValue()).forEach(entry -> {
            logger.debug("ConcurrentSoftReferenceStore({}) evicted [{}]", (Object)this.provider.getName(), (Object)entry.key());
            this.getPool().remove(entry.key());
            this.getProvider().getStats().recordEviction();
        });
        this.evictSoftReferences();
    }

    @Override
    public int getSize() {
        return this.getPool().size();
    }

    @Override
    public void clearAll() {
        this.getPool().clear();
        this.softRefKeyMap.clear();
    }

    @Override
    public boolean clearAll(ICacheKeyFilter filter) {
        this.softRefKeyMap.values().removeIf(filter);
        return this.getPool().keySet().removeIf(filter);
    }

    @Override
    public boolean clear(Key key) {
        SoftReference<ICacheEntry> reference = this.pool.remove(key);
        if (reference != null) {
            this.softRefKeyMap.remove(reference.hashCode());
            return true;
        }
        return false;
    }

    @Override
    public IStruct clear(Key ... keys) {
        Struct results = new Struct();
        for (Key key : keys) {
            results.put(key, (Object)this.clear(key));
        }
        return results;
    }

    @Override
    public Key[] getKeys() {
        return this.getPool().keySet().toArray(new Key[0]);
    }

    @Override
    public Key[] getKeys(ICacheKeyFilter filter) {
        return (Key[])this.getPool().keySet().parallelStream().filter(filter).toArray(Key[]::new);
    }

    @Override
    public Stream<Key> getKeysStream() {
        return this.getPool().keySet().stream();
    }

    @Override
    public Stream<Key> getKeysStream(ICacheKeyFilter filter) {
        return this.getPool().keySet().stream().filter(filter);
    }

    @Override
    public boolean lookup(Key key) {
        SoftReference<ICacheEntry> entry = this.pool.get(key);
        if (entry != null) {
            ICacheEntry cacheEntry = entry.get();
            if (cacheEntry == null) {
                this.clear(key);
                this.getProvider().getStats().recordGCHit();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public IStruct lookup(Key ... keys) {
        Struct results = new Struct();
        for (Key key : keys) {
            results.put(key, (Object)this.lookup(key));
        }
        return results;
    }

    @Override
    public IStruct lookup(ICacheKeyFilter filter) {
        Struct results = new Struct();
        this.getPool().keySet().parallelStream().filter(filter).forEach(key -> results.put((Key)key, (Object)true));
        return results;
    }

    @Override
    public ICacheEntry get(Key key) {
        ICacheEntry results = this.getQuiet(key);
        if (results != null) {
            results.incrementHits().touchLastAccessed();
            if (this.config.getAsBoolean(Key.resetTimeoutOnAccess).booleanValue()) {
                results.resetCreated();
            }
        }
        return results;
    }

    @Override
    public IStruct get(Key ... keys) {
        Struct results = new Struct();
        for (Key key : keys) {
            results.put(key, (Object)this.get(key));
        }
        return results;
    }

    @Override
    public IStruct get(ICacheKeyFilter filter) {
        Struct results = new Struct();
        this.getPool().keySet().parallelStream().filter(filter).forEach(key -> results.put((Key)key, (Object)this.get((Key)key)));
        return results;
    }

    @Override
    public IStruct getQuiet(Key ... keys) {
        Struct results = new Struct();
        for (Key key : keys) {
            results.put(key, (Object)this.getQuiet(key));
        }
        return results;
    }

    @Override
    public IStruct getQuiet(ICacheKeyFilter filter) {
        Struct results = new Struct();
        this.getPool().keySet().parallelStream().filter(filter).forEach(key -> results.put((Key)key, (Object)this.getQuiet((Key)key)));
        return results;
    }

    @Override
    public ICacheEntry getQuiet(Key key) {
        SoftReference<ICacheEntry> reference = this.pool.get(key);
        if (reference != null) {
            ICacheEntry cacheEntry = reference.get();
            if (cacheEntry == null) {
                this.clear(key);
                this.getProvider().getStats().recordGCHit();
            } else {
                return cacheEntry;
            }
        }
        return null;
    }

    @Override
    public void set(Key key, ICacheEntry entry) {
        SoftReference<ICacheEntry> softReference = this.createSoftReference(key, entry);
        this.pool.put(key, softReference);
    }

    @Override
    public void set(IStruct entries) {
        entries.forEach((key, value) -> this.set((Key)key, (ICacheEntry)value));
    }

    public synchronized void evictSoftReferences() {
        SoftReference collected;
        while ((collected = (SoftReference)this.referenceQueue.poll()) != null) {
            if (!this.verifySoftReference(collected)) continue;
            this.clear(this.getSoftReferenceKey(collected));
            this.softRefKeyMap.remove(collected.hashCode());
            this.getProvider().getStats().recordGCHit();
        }
    }

    private SoftReference<ICacheEntry> createSoftReference(Key key, ICacheEntry entry) {
        SoftReference<ICacheEntry> softReference = new SoftReference<ICacheEntry>(entry, this.referenceQueue);
        this.softRefKeyMap.put(softReference.hashCode(), key);
        return softReference;
    }

    private boolean verifySoftReference(SoftReference<ICacheEntry> softReference) {
        return this.softRefKeyMap.containsKey(softReference.hashCode());
    }

    private Key getSoftReferenceKey(SoftReference<ICacheEntry> softReference) {
        return this.softRefKeyMap.get(softReference.hashCode());
    }
}

