/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.cache.store;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.cache.ICacheEntry;
import ortus.boxlang.runtime.cache.filters.ICacheKeyFilter;
import ortus.boxlang.runtime.cache.providers.ICacheProvider;
import ortus.boxlang.runtime.cache.store.AbstractStore;
import ortus.boxlang.runtime.cache.store.IObjectStore;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;

public class ConcurrentStore
extends AbstractStore {
    private static final Logger logger = LoggerFactory.getLogger(ConcurrentStore.class);
    private ConcurrentHashMap<Key, ICacheEntry> pool;

    @Override
    public IObjectStore init(ICacheProvider provider, IStruct config) {
        this.provider = provider;
        this.config = config;
        this.pool = new ConcurrentHashMap(config.getAsInteger(Key.maxObjects) / 4);
        logger.debug("ConcurrentStore({}) initialized with a max size of {}", (Object)provider.getName(), (Object)config.getAsInteger(Key.maxObjects));
        return this;
    }

    public ConcurrentMap<Key, ICacheEntry> getPool() {
        return this.pool;
    }

    @Override
    public void shutdown() {
        this.getPool().clear();
        logger.debug("ConcurrentStore({}) was shutdown", (Object)this.provider.getName());
    }

    @Override
    public int flush() {
        logger.debug("ConcurrentStore({}) was flushed", (Object)this.provider.getName());
        return 0;
    }

    @Override
    public synchronized void evict() {
        if (this.config.getAsInteger(Key.evictCount) == 0) {
            return;
        }
        this.getPool().entrySet().parallelStream().sorted(Map.Entry.comparingByValue(this.getPolicy().getComparator())).filter(entry -> !((ICacheEntry)entry.getValue()).isEternal()).limit(this.config.getAsInteger(Key.evictCount).intValue()).forEach(entry -> {
            logger.debug("ConcurrentStore({}) evicted [{}]", (Object)this.provider.getName(), entry.getKey());
            this.getPool().remove(entry.getKey());
            this.getProvider().getStats().recordEviction();
        });
    }

    @Override
    public int getSize() {
        return this.getPool().size();
    }

    @Override
    public void clearAll() {
        this.getPool().clear();
    }

    @Override
    public boolean clearAll(ICacheKeyFilter filter) {
        return this.getPool().keySet().removeIf(filter);
    }

    @Override
    public boolean clear(Key key) {
        return this.getPool().remove(key) != null;
    }

    @Override
    public IStruct clear(Key ... keys) {
        Struct results = new Struct();
        for (Key key : keys) {
            results.put(key, (Object)this.clear(key));
        }
        return results;
    }

    @Override
    public Key[] getKeys() {
        return this.getPool().keySet().toArray(new Key[0]);
    }

    @Override
    public Key[] getKeys(ICacheKeyFilter filter) {
        return (Key[])this.getPool().keySet().parallelStream().filter(filter).toArray(Key[]::new);
    }

    @Override
    public Stream<Key> getKeysStream() {
        return this.getPool().keySet().stream();
    }

    @Override
    public Stream<Key> getKeysStream(ICacheKeyFilter filter) {
        return this.getPool().keySet().stream().filter(filter);
    }

    @Override
    public boolean lookup(Key key) {
        return this.getPool().containsKey(key);
    }

    @Override
    public IStruct lookup(Key ... keys) {
        Struct results = new Struct();
        for (Key key : keys) {
            results.put(key, (Object)this.lookup(key));
        }
        return results;
    }

    @Override
    public IStruct lookup(ICacheKeyFilter filter) {
        Struct results = new Struct();
        this.getPool().keySet().parallelStream().filter(filter).forEach(key -> results.put((Key)key, (Object)true));
        return results;
    }

    @Override
    public ICacheEntry get(Key key) {
        ICacheEntry results = this.getQuiet(key);
        if (results != null) {
            results.incrementHits().touchLastAccessed();
            if (this.config.getAsBoolean(Key.resetTimeoutOnAccess).booleanValue()) {
                results.resetCreated();
            }
        }
        return results;
    }

    @Override
    public IStruct get(Key ... keys) {
        Struct results = new Struct();
        for (Key key : keys) {
            results.put(key, (Object)this.get(key));
        }
        return results;
    }

    @Override
    public IStruct get(ICacheKeyFilter filter) {
        Struct results = new Struct();
        this.getPool().keySet().parallelStream().filter(filter).forEach(key -> results.put((Key)key, (Object)this.get((Key)key)));
        return results;
    }

    @Override
    public ICacheEntry getQuiet(Key key) {
        return this.getPool().getOrDefault(key, null);
    }

    @Override
    public IStruct getQuiet(Key ... keys) {
        Struct results = new Struct();
        for (Key key : keys) {
            results.put(key, (Object)this.getQuiet(key));
        }
        return results;
    }

    @Override
    public IStruct getQuiet(ICacheKeyFilter filter) {
        Struct results = new Struct();
        this.getPool().keySet().parallelStream().filter(filter).forEach(key -> results.put((Key)key, (Object)this.getQuiet((Key)key)));
        return results;
    }

    @Override
    public void set(Key key, ICacheEntry entry) {
        this.getPool().put(key, entry);
    }

    @Override
    public void set(IStruct entries) {
        entries.forEach((key, value) -> this.set((Key)key, (ICacheEntry)value));
    }
}

