/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.cache.store;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.cache.BoxCacheEntry;
import ortus.boxlang.runtime.cache.ICacheEntry;
import ortus.boxlang.runtime.cache.filters.ICacheKeyFilter;
import ortus.boxlang.runtime.cache.providers.ICacheProvider;
import ortus.boxlang.runtime.cache.store.AbstractStore;
import ortus.boxlang.runtime.cache.store.IObjectStore;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.types.util.BLCollector;
import ortus.boxlang.runtime.util.FileSystemUtil;

public class FileSystemStore
extends AbstractStore {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemStore.class);
    private static final String FILE_EXTENSION = ".cache";
    private static final PathMatcher cacheFileMatcher = FileSystems.getDefault().getPathMatcher("glob:*.cache");
    private Path directory;

    @Override
    public IObjectStore init(ICacheProvider provider, IStruct config) {
        this.provider = provider;
        this.config = config;
        this.directory = Path.of(config.getAsString(Key.directory), new String[0]).toAbsolutePath();
        try {
            Files.createDirectories(this.directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
        logger.debug("FileSystemStore({}) initialized with a max size of {}", (Object)provider.getName(), (Object)config.getAsInteger(Key.maxObjects));
        return this;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public Key pathToCacheKey(Path path) {
        return Key.of(FilenameUtils.removeExtension(path.getFileName().toString()));
    }

    public Path cacheKeyToPath(Key key) {
        return Path.of(this.directory.toString(), key.getNameNoCase() + FILE_EXTENSION).toAbsolutePath();
    }

    @Override
    public void shutdown() {
        logger.debug("FileSystemStore({}) was shutdown", (Object)this.provider.getName());
    }

    @Override
    public int flush() {
        logger.debug("FileSystemStore({}) was flushed", (Object)this.provider.getName());
        return 0;
    }

    @Override
    public synchronized void evict() {
        if (this.config.getAsInteger(Key.evictCount) == 0) {
            return;
        }
        ((Stream)this.getEntryStream().parallel()).map(path -> (BoxCacheEntry)this.getQuiet(this.pathToCacheKey((Path)path))).sorted(this.getPolicy().getComparator()).filter(entry -> !entry.isEternal()).limit(this.config.getAsInteger(Key.evictCount).intValue()).forEach(entry -> {
            logger.debug("FileSystemStore({}) evicted [{}]", (Object)this.provider.getName(), (Object)entry.key().getName());
            try {
                Files.delete(Path.of(entry.metadata().getAsString(Key.path), new String[0]));
            }
            catch (IOException e) {
                throw new BoxIOException(e);
            }
            this.getProvider().getStats().recordEviction();
        });
    }

    @Override
    public int getSize() {
        return (int)this.getEntryStream().count();
    }

    @Override
    public void clearAll() {
        try {
            FileUtils.cleanDirectory(this.directory.toFile());
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    @Override
    public boolean clearAll(ICacheKeyFilter filter) {
        ((Stream)this.getEntryStream(filter).parallel()).forEach(path -> {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                throw new BoxIOException(e);
            }
        });
        return true;
    }

    @Override
    public boolean clear(Key key) {
        Path target = this.cacheKeyToPath(key);
        if (!Files.exists(target, new LinkOption[0])) {
            return false;
        }
        try {
            Files.delete(target);
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
        return true;
    }

    @Override
    public IStruct clear(Key ... keys) {
        Struct results = new Struct();
        for (Key key : keys) {
            results.put(key, (Object)this.clear(key));
        }
        return results;
    }

    @Override
    public Key[] getKeys() {
        return (Key[])this.getEntryStream().map(this::pathToCacheKey).toArray(Key[]::new);
    }

    @Override
    public Key[] getKeys(ICacheKeyFilter filter) {
        return (Key[])this.getEntryStream(filter).map(this::pathToCacheKey).toArray(Key[]::new);
    }

    @Override
    public Stream<Key> getKeysStream() {
        return this.getEntryStream().map(this::pathToCacheKey);
    }

    @Override
    public Stream<Key> getKeysStream(ICacheKeyFilter filter) {
        return this.getEntryStream(filter).map(this::pathToCacheKey);
    }

    @Override
    public boolean lookup(Key key) {
        return this.getEntryStream().anyMatch(path -> key.equals(this.pathToCacheKey((Path)path)));
    }

    @Override
    public IStruct lookup(Key ... keys) {
        Struct results = new Struct();
        for (Key key : keys) {
            results.put(key, (Object)this.lookup(key));
        }
        return results;
    }

    @Override
    public IStruct lookup(ICacheKeyFilter filter) {
        Key[] foundKeys = (Key[])this.getEntryStream(filter).map(this::pathToCacheKey).toArray(Key[]::new);
        return Stream.of(foundKeys).map(key -> new AbstractMap.SimpleEntry<Key, Boolean>((Key)key, this.lookup((Key)key))).collect(BLCollector.toStruct());
    }

    @Override
    public ICacheEntry get(Key key) {
        ICacheEntry results = this.getQuiet(key);
        if (results != null) {
            results.incrementHits().touchLastAccessed();
            if (this.config.getAsBoolean(Key.resetTimeoutOnAccess).booleanValue()) {
                results.resetCreated();
            }
        }
        return results;
    }

    @Override
    public IStruct get(Key ... keys) {
        Struct results = new Struct();
        for (Key key : keys) {
            results.put(key, (Object)this.get(key));
        }
        return results;
    }

    @Override
    public IStruct get(ICacheKeyFilter filter) {
        Struct results = new Struct();
        this.getEntryStream(filter).forEach(key -> results.put(this.pathToCacheKey((Path)key), (Object)this.get(this.pathToCacheKey((Path)key))));
        return results;
    }

    @Override
    public ICacheEntry getQuiet(Key key) {
        Path foundEntry = this.getEntryStream().filter(path -> key.equals(this.pathToCacheKey((Path)path))).findFirst().orElse(null);
        return foundEntry == null ? null : this.deserializeEntry(foundEntry);
    }

    @Override
    public IStruct getQuiet(Key ... keys) {
        Struct results = new Struct();
        for (Key key : keys) {
            results.put(key, (Object)this.getQuiet(key));
        }
        return results;
    }

    @Override
    public IStruct getQuiet(ICacheKeyFilter filter) {
        Struct results = new Struct();
        this.getEntryStream(filter).forEach(key -> results.put(this.pathToCacheKey((Path)key), (Object)this.getQuiet(this.pathToCacheKey((Path)key))));
        return results;
    }

    @Override
    public void set(Key key, ICacheEntry entry) {
        Path filePath = this.cacheKeyToPath(key);
        entry.metadata().put(Key.path, (Object)filePath.toString());
        FileSystemUtil.serializeToFile(entry, filePath);
    }

    @Override
    public void set(IStruct entries) {
        entries.forEach((key, value) -> this.set((Key)key, (ICacheEntry)value));
    }

    private Stream<Path> getEntryStream() {
        try {
            return Files.walk(this.directory, 1, new FileVisitOption[0]).filter(path -> cacheFileMatcher.matches(path.getFileName()));
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    private Stream<Path> getEntryStream(ICacheKeyFilter filter) {
        return this.getEntryStream().map(this::pathToCacheKey).filter(filter).map(this::cacheKeyToPath);
    }

    private ICacheEntry deserializeEntry(Path entryPath) {
        Object result = FileSystemUtil.deserializeFromFile(entryPath);
        if (result instanceof ICacheEntry) {
            return (ICacheEntry)result;
        }
        return new BoxCacheEntry(Key.of(this.directory.toString()), 0L, 0L, this.pathToCacheKey(entryPath), result, new Struct());
    }
}

