/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.cache.store;

import ortus.boxlang.runtime.cache.providers.CoreProviderType;
import ortus.boxlang.runtime.cache.store.BlackHoleStore;
import ortus.boxlang.runtime.cache.store.ConcurrentSoftReferenceStore;
import ortus.boxlang.runtime.cache.store.ConcurrentStore;
import ortus.boxlang.runtime.cache.store.FileSystemStore;
import ortus.boxlang.runtime.cache.store.IObjectStore;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public enum ObjectStoreType {
    BLACKHOLE(Key.of("BlackHoleStore")),
    CONCURRENT(Key.of("ConcurrentStore")),
    CONCURRENT_SOFT_REFERENCE(Key.of("ConcurrentSoftReferenceStore")),
    DISK(Key.of("FileSystemStore")),
    JDBC(Key.of("JDBCStore"));

    private final Key key;

    private ObjectStoreType(Key name) {
        this.key = name;
    }

    public Key getKey() {
        return this.key;
    }

    public static ObjectStoreType getValueByKey(Key key) {
        for (ObjectStoreType store : ObjectStoreType.values()) {
            if (!store.getKey().equals(key)) continue;
            return store;
        }
        throw new BoxRuntimeException("No Core Object Store" + ObjectStoreType.class.getCanonicalName() + " with key " + String.valueOf(key));
    }

    public IObjectStore buildStore() {
        switch (this.ordinal()) {
            case 0: {
                return new BlackHoleStore();
            }
            case 1: {
                return new ConcurrentStore();
            }
            case 2: {
                return new ConcurrentSoftReferenceStore();
            }
            case 3: {
                return new FileSystemStore();
            }
        }
        throw new BoxRuntimeException("No Object Store " + CoreProviderType.class.getCanonicalName());
    }

    public static boolean isCore(Key value) {
        for (ObjectStoreType store : ObjectStoreType.values()) {
            if (!store.getKey().equals(value)) continue;
            return true;
        }
        return false;
    }
}

