/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.cache.util;

import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import ortus.boxlang.runtime.cache.util.ICacheStats;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;

public class BoxCacheStats
implements ICacheStats {
    private AtomicLong garbageCollections;
    private AtomicLong evictionCount;
    private AtomicLong hits;
    private AtomicLong misses;
    private Instant lastReapDatetime;
    private AtomicLong reapCount;
    private Instant started;
    private long size;

    public BoxCacheStats() {
        this.reset();
    }

    @Override
    public ICacheStats recordEviction() {
        this.evictionCount.incrementAndGet();
        return this;
    }

    @Override
    public ICacheStats recordHit() {
        this.hits.incrementAndGet();
        return this;
    }

    @Override
    public ICacheStats recordMiss() {
        this.misses.incrementAndGet();
        return this;
    }

    @Override
    public ICacheStats recordGCHit() {
        this.garbageCollections.incrementAndGet();
        return this;
    }

    @Override
    public ICacheStats recordReap() {
        this.reapCount.incrementAndGet();
        this.lastReapDatetime = Instant.now();
        return this;
    }

    @Override
    public int hitRate() {
        long _hits = this.hits.get();
        long _misses = this.misses.get();
        if (_hits == 0L && _misses == 0L) {
            return 0;
        }
        return (int)(_hits / (_hits + _misses) * 100L);
    }

    @Override
    public int objectCount() {
        return 0;
    }

    @Override
    public int expiredCount() {
        return 0;
    }

    @Override
    public ICacheStats reset() {
        this.garbageCollections = new AtomicLong(0L);
        this.evictionCount = new AtomicLong(0L);
        this.hits = new AtomicLong(0L);
        this.misses = new AtomicLong(0L);
        this.lastReapDatetime = Instant.now();
        this.reapCount = new AtomicLong(0L);
        this.started = Instant.now();
        this.size = 0L;
        return this;
    }

    @Override
    public long garbageCollections() {
        return this.garbageCollections.get();
    }

    @Override
    public long evictionCount() {
        return this.evictionCount.get();
    }

    @Override
    public long hits() {
        return this.hits.get();
    }

    @Override
    public long misses() {
        return this.misses.get();
    }

    @Override
    public Instant lastReapDatetime() {
        return this.lastReapDatetime;
    }

    @Override
    public long reapCount() {
        return this.reapCount.get();
    }

    @Override
    public Instant started() {
        return this.started;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public IStruct toStruct() {
        return Struct.of(new Object[]{"garbageCollections", this.garbageCollections.get(), "evictionCount", this.evictionCount.get(), "hits", this.hits.get(), "misses", this.misses.get(), "lastReapDatetime", this.lastReapDatetime, "reapCount", this.reapCount.get(), "started", this.started, "size", this.size(), "objectCount", this.objectCount(), "expiredCount", this.expiredCount()});
    }
}

