/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.cache.util;

import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.CacheService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.validation.Validatable;
import ortus.boxlang.runtime.validation.Validator;

public class CacheExistsValidator
implements Validator {
    private static final CacheService cacheService = BoxRuntime.getInstance().getCacheService();

    @Override
    public void validate(IBoxContext context, Key caller, Validatable record, IStruct records) {
        Object cacheName = records.get(record.name());
        if (cacheName instanceof String) {
            String castedCacheName = (String)cacheName;
            cacheName = Key.of(castedCacheName);
        }
        if (!cacheService.hasCache((Key)cacheName)) {
            throw new BoxValidationException(caller, record, "Cache " + String.valueOf(cacheName) + " does not exist. Available caches are: " + String.valueOf(cacheService.getRegisteredCaches()));
        }
        records.put(record.name(), cacheName);
    }
}

