/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components;

import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.ComponentService;
import ortus.boxlang.runtime.services.FunctionService;
import ortus.boxlang.runtime.services.InterceptorService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;

public abstract class Component {
    public static final BodyResult DEFAULT_RETURN = BodyResult.ofDefault();
    protected Key name;
    protected Attribute[] declaredAttributes = new Attribute[0];
    protected BoxRuntime runtime = BoxRuntime.getInstance();
    protected ComponentService componentService = BoxRuntime.getInstance().getComponentService();
    protected FunctionService functionService = BoxRuntime.getInstance().getFunctionService();
    protected InterceptorService interceptorService = BoxRuntime.getInstance().getInterceptorService();

    protected Component() {
    }

    public Component setName(Key name) {
        this.name = name;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BodyResult invoke(IBoxContext context, IStruct attributes, ComponentBody body) {
        this.validateAttributes(context, attributes);
        Struct executionState = new Struct();
        executionState.put(Key._NAME, (Object)this.name);
        executionState.put(Key._CLASS, (Object)this.getClass());
        executionState.put(Key.attributes, (Object)attributes);
        executionState.put(Key.dataCollection, (Object)Struct.of(new Object[0]));
        context.pushComponent(executionState);
        try {
            BodyResult bodyResult = this._invoke(context, attributes, body, executionState);
            return bodyResult;
        }
        finally {
            context.popComponent();
        }
    }

    public abstract BodyResult _invoke(IBoxContext var1, IStruct var2, ComponentBody var3, IStruct var4);

    public void announce(Key state, IStruct data) {
        this.interceptorService.announce(state, data);
    }

    public void validateAttributes(IBoxContext context, IStruct attributes) {
    }

    public BodyResult processBody(IBoxContext context, ComponentBody body) {
        return this.processBody(context, body, null);
    }

    public BodyResult processBody(IBoxContext context, ComponentBody body, StringBuffer buffer) {
        String bufferResult = null;
        BodyResult returnValue = DEFAULT_RETURN;
        if (body != null) {
            if (buffer != null) {
                context.pushBuffer(buffer);
                try {
                    returnValue = body.process(context);
                }
                catch (Throwable e) {
                    bufferResult = buffer.toString();
                    context.writeToBuffer(bufferResult);
                    throw e;
                }
                finally {
                    context.popBuffer();
                }
            } else {
                returnValue = body.process(context);
            }
        }
        return returnValue;
    }

    public Key getName() {
        return this.name;
    }

    public Attribute[] getDeclaredAttributes() {
        return this.declaredAttributes;
    }

    @FunctionalInterface
    public static interface ComponentBody {
        public BodyResult process(IBoxContext var1);
    }

    public record BodyResult(int resultType, Object returnValue, String label) {
        public static final int DEFAULT = 0;
        public static final int RETURN = 1;
        public static final int BREAK = 2;
        public static final int CONTINUE = 3;

        public static BodyResult ofBreak(String label) {
            return new BodyResult(2, null, label);
        }

        public static BodyResult ofContinue(String label) {
            return new BodyResult(3, null, label);
        }

        public static BodyResult ofReturn(Object returnValue) {
            return new BodyResult(1, returnValue, null);
        }

        public static BodyResult ofDefault() {
            return new BodyResult(0, null, null);
        }

        public boolean isBreak(String label) {
            return this.resultType == 2 && (this.label == null || this.label.equals(label));
        }

        public boolean isContinue(String label) {
            return this.resultType == 3 && (this.label == null || this.label.equals(label));
        }

        public boolean isBreak() {
            return this.resultType == 2;
        }

        public boolean isContinue() {
            return this.resultType == 3;
        }

        public boolean isReturn() {
            return this.resultType == 1;
        }

        public boolean isEarlyExit() {
            return this.isBreak() || this.isContinue() || this.isReturn();
        }
    }
}

