/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.InterceptorService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.validation.Validatable;
import ortus.boxlang.runtime.validation.Validator;

public class ComponentDescriptor {
    public Key name;
    public Boolean allowsBody;
    public Boolean requiresBody;
    public Class<?> componentClass;
    public String module;
    public volatile Component componentInstance;
    protected InterceptorService interceptorService = BoxRuntime.getInstance().getInterceptorService();

    public ComponentDescriptor(Key name, Class<?> componentClass, String module, String namespace, Component componentInstance, Boolean allowsBody, Boolean requiresBody) {
        this.name = name;
        this.componentClass = componentClass;
        this.module = module;
        this.componentInstance = componentInstance;
        this.allowsBody = allowsBody;
        this.requiresBody = requiresBody;
    }

    public Boolean hasModule() {
        return this.module != null;
    }

    public Boolean allowsBody() {
        return this.allowsBody != false || this.requiresBody != false;
    }

    public Boolean requiresBody() {
        return this.requiresBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent() {
        if (this.componentInstance == null) {
            ComponentDescriptor componentDescriptor = this;
            synchronized (componentDescriptor) {
                if (this.componentInstance == null) {
                    this.componentInstance = ((Component)DynamicObject.of(this.componentClass).invokeConstructor((IBoxContext)null, new Object[0]).getTargetInstance()).setName(this.name);
                    this.interceptorService.announce(BoxEvent.ON_COMPONENT_INSTANCE, (IStruct)new Struct(Map.of(Key.instance, this.componentInstance, Key._NAME, this.name, Key.descriptor, this)));
                }
            }
        }
        return this.componentInstance;
    }

    public Component.BodyResult invoke(IBoxContext context, Component.ComponentBody componentBody) {
        return this.invoke(context, Struct.EMPTY, componentBody);
    }

    public Component.BodyResult invoke(IBoxContext context, IStruct attributes, Component.ComponentBody componentBody) {
        Object object;
        if (this.name.equals(Key.module)) {
            return this.invokeModule(context, attributes, componentBody);
        }
        Component component = this.getComponent();
        if (attributes.containsKey(Key.attributeCollection) && (object = attributes.get(Key.attributeCollection)) instanceof IStruct) {
            IStruct attrCol = (IStruct)object;
            for (Key key : attrCol.keySet()) {
                if (attributes.containsKey(key)) continue;
                attributes.put(key, attrCol.get(key));
            }
            attributes.remove(Key.attributeCollection);
        }
        for (Attribute attribute : component.getDeclaredAttributes()) {
            Validator.TYPE.validate(context, component.getName(), attribute, attributes);
            attribute.validate(context, component.getName(), attributes);
            Validator.DEFAULT_VALUE.validate(context, component.getName(), attribute, attributes);
        }
        return component.invoke(context, attributes, componentBody);
    }

    public Component.BodyResult invokeModule(IBoxContext context, IStruct attributes, Component.ComponentBody componentBody) {
        Iterator iterator;
        Component component = this.getComponent();
        Struct moduleAttributes = new Struct();
        ArrayList<Key> keysToRemove = new ArrayList<Key>();
        for (Key key : attributes.keySet()) {
            if (key.equals(Key._NAME) || key.equals(Key.template)) continue;
            moduleAttributes.put(key, attributes.get(key));
            keysToRemove.add(key);
        }
        for (Key key : keysToRemove) {
            attributes.remove(key);
        }
        if (moduleAttributes.containsKey(Key.attributeCollection) && (iterator = moduleAttributes.get(Key.attributeCollection)) instanceof IStruct) {
            IStruct attrCol = (IStruct)((Object)iterator);
            for (Key key : attrCol.keySet()) {
                if (moduleAttributes.containsKey(key)) continue;
                moduleAttributes.put(key, attrCol.get(key));
            }
            moduleAttributes.remove(Key.attributeCollection);
        }
        attributes.put(Key.attributes, (Object)moduleAttributes);
        for (Iterator<Object> iterator2 : component.getDeclaredAttributes()) {
            Validator.TYPE.validate(context, component.getName(), (Validatable)((Object)iterator2), attributes);
            iterator2.validate(context, component.getName(), attributes);
            Validator.DEFAULT_VALUE.validate(context, component.getName(), (Validatable)((Object)iterator2), attributes);
        }
        return component.invoke(context, attributes, componentBody);
    }
}

