/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components.async;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.context.ThreadBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.AbortException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.BLCollector;
import ortus.boxlang.runtime.types.util.ListUtil;
import ortus.boxlang.runtime.util.RequestThreadManager;
import ortus.boxlang.runtime.validation.Validator;

@BoxComponent(allowsBody=true)
public class Thread
extends Component {
    private static final Logger logger = LoggerFactory.getLogger(Thread.class);

    public Thread() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key._NAME, "string"), new Attribute(Key.action, "string", "run", Set.of(Validator.valueOneOf("join", "run", "sleep", "terminate"), Validator.valueRequires("sleep", Key.duration))), new Attribute(Key.duration, "integer", 0, Set.of(Validator.min(0))), new Attribute(Key.priority, "string", "normal", Set.of(Validator.valueOneOf("high", "low", "normal"))), new Attribute(Key.timeout, "integer")};
    }

    @Override
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        Key action = Key.of(attributes.getAsString(Key.action));
        String name = attributes.getAsString(Key._NAME);
        Integer duration = attributes.getAsInteger(Key.duration);
        String priority = attributes.getAsString(Key.priority);
        Integer timeout = attributes.getAsInteger(Key.timeout);
        if (action.equals(Key.join)) {
            this.join(context, name, timeout);
        } else if (action.equals(Key.run)) {
            this.run(context, name, priority, attributes, body);
        } else if (action.equals(Key.sleep)) {
            this.sleep(context, duration);
        } else if (action.equals(Key.terminate)) {
            this.terminate(context, name);
        } else {
            throw new BoxRuntimeException("Invalid thread action [" + String.valueOf(action) + "]. Valid actions are [join, run, sleep, terminate]");
        }
        return DEFAULT_RETURN;
    }

    private void run(IBoxContext context, String name, String priority, IStruct attributes, Component.ComponentBody body) {
        RequestThreadManager threadManager = context.getParentOfType(RequestBoxContext.class).getThreadManager();
        Key nameKey = RequestThreadManager.ensureThreadName(name);
        ThreadBoxContext tContext = threadManager.createThreadContext(context, nameKey);
        threadManager.startThread(tContext, nameKey, priority, () -> {
            StringBuffer buffer = new StringBuffer();
            Throwable exception = null;
            Logger logger2 = LoggerFactory.getLogger(Thread.class);
            try {
                this.processBody(tContext, body, buffer);
            }
            catch (AbortException e) {
                logger2.debug("Thread [{}] aborted at stacktrace: {}", (Object)nameKey.getName(), (Object)e.getStackTrace());
            }
            catch (Throwable e) {
                exception = e;
                logger2.error("Thread [{}] terminated with exception: {}", (Object)nameKey.getName(), (Object)e.getMessage());
                logger2.error("-> Exception", e);
            }
            finally {
                threadManager.completeThread(nameKey, buffer.toString(), exception, java.lang.Thread.interrupted());
            }
        }, attributes);
    }

    private void join(IBoxContext context, String name, Integer timeout) {
        timeout = timeout == null ? 0 : timeout;
        RequestThreadManager threadManager = context.getParentOfType(RequestBoxContext.class).getThreadManager();
        Array aThreadNames = ListUtil.asList(name, ",").stream().map(String::valueOf).map(String::trim).collect(BLCollector.toArray());
        if (aThreadNames.isEmpty()) {
            threadManager.joinAllThreads(timeout);
        } else {
            threadManager.joinThreads(aThreadNames, timeout);
        }
    }

    private void terminate(IBoxContext context, String name) {
        context.getParentOfType(RequestBoxContext.class).getThreadManager().terminateThread(Key.of(name));
    }

    private void sleep(IBoxContext context, Integer duration) {
        context.invokeFunction(Key.sleep, new Object[]{duration});
    }
}

