/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components.cache;

import java.time.Duration;
import java.util.List;
import java.util.Set;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.cache.providers.ICacheProvider;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.Attempt;
import ortus.boxlang.runtime.dynamic.ExpressionInterpreter;
import ortus.boxlang.runtime.dynamic.casters.DoubleCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.CacheService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.validation.Validator;

@BoxComponent(allowsBody=true)
public class Cache
extends Component {
    public static final double secondsInDay = 86400.0;
    protected final CacheService cacheService = BoxRuntime.getInstance().getCacheService();
    protected ICacheProvider defaultCache = this.cacheService.getDefaultCache();
    private final String defaultFileStore = "FileSystemStore";

    public Cache() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key.action, "string", "cache", Set.of(Validator.valueOneOf("cache", "flush", "clientcache", "servercache", "optimal", "content", "put", "get"))), new Attribute(Key.key, "string"), new Attribute(Key.value, "any"), new Attribute(Key._NAME, "any"), new Attribute(Key.cacheName, "string"), new Attribute(Key.metadata, "struct"), new Attribute(Key.directory, "string"), new Attribute(Key.timespan, "double"), new Attribute(Key.idleTime, "double"), new Attribute(Key.metadata, "struct"), new Attribute(Key.stripWhitespace, "boolean", false), new Attribute(Key.throwOnError, "boolean", false), new Attribute(Key.useCache, "boolean", true), new Attribute(Key.expireURL, "string", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.password, "string", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.port, "integer", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.protocol, "string", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.region, "string", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.useQueryString, "boolean", false, Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.username, "string", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.dependsOn, "string", Set.of(Validator.NOT_IMPLEMENTED))};
    }

    @Override
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        String cacheKeyName;
        CacheAction cacheAction = CacheAction.fromString(attributes.getAsString(Key.action));
        String key = attributes.getAsString(Key.key);
        Object value = attributes.get(Key.value);
        String variable = attributes.getAsString(Key._NAME);
        String cacheName = attributes.getAsString(Key.cacheName);
        String cacheDirectory = attributes.getAsString(Key.directory);
        Boolean useCache = attributes.getAsBoolean(Key.useCache);
        Double timespan = attributes.getAsDouble(Key.timespan);
        Double idleTime = attributes.getAsDouble(Key.idleTime);
        Boolean throwOnError = attributes.getAsBoolean(Key.throwOnError);
        ICacheProvider cacheProvider = null;
        List<CacheAction> namedCacheOps = List.of(CacheAction.GET, CacheAction.PUT, CacheAction.CACHE, CacheAction.OPTIMAL, CacheAction.CONTENT, CacheAction.FLUSH, CacheAction.DELETE);
        List<CacheAction> keyRequiredActions = List.of(CacheAction.GET, CacheAction.PUT);
        if (key == null && attributes.containsKey(Key.id)) {
            key = attributes.getAsString(Key.id);
        }
        if (key == null && keyRequiredActions.contains((Object)cacheAction)) {
            throw new BoxRuntimeException(String.format("An explict key attribute is required for the cache action [%s]", cacheAction.toString().toLowerCase()));
        }
        String string = cacheKeyName = key != null ? key : StringCaster.cast(this.runtime.getFunctionService().getGlobalFunction(Key.hash40).invoke(context, ArgumentsScope.of(new Object[]{Key.input, Struct.of(new Object[]{Key.attributes, attributes, Key.body, body})}), false, Key.hash40));
        if (timespan == null && idleTime != null) {
            timespan = idleTime;
        }
        Object result = null;
        if (!useCache.booleanValue()) {
            if (cacheAction.equals((Object)CacheAction.CLIENTCACHE) || cacheAction.equals((Object)CacheAction.SERVERCACHE)) {
                return DEFAULT_RETURN;
            }
            result = value == null ? this.processCacheBody(context, body) : value;
        }
        if (!namedCacheOps.contains((Object)cacheAction)) {
            IStruct interceptorArgs = Struct.of(new Object[]{Key.component, this, Key.context, context, Key.attributes, attributes, Key.body, body, Key.executionState, executionState, Key.result, null});
            this.interceptorService.announce(BoxEvent.ON_CREATEOBJECT_REQUEST, interceptorArgs);
            if (interceptorArgs.get(Key.result) == null) {
                throw new BoxRuntimeException(String.format("The specified cache action [%s] is is not valid in the current runtime", cacheAction.toString().toLowerCase()));
            }
        } else {
            if (cacheName != null) {
                cacheProvider = this.cacheService.getCache(Key.of(cacheName));
            } else if (cacheDirectory != null) {
                Key directoryCacheKey = Key.of(cacheDirectory);
                if (!this.cacheService.hasCache(directoryCacheKey)) {
                    this.cacheService.createCache(directoryCacheKey, Key.boxCacheProvider, Struct.of(new Object[]{Key.objectStore, "FileSystemStore", Key.directory, cacheDirectory, Key.useLastAccessTimeouts, true}));
                }
                cacheProvider = this.cacheService.getCache(directoryCacheKey);
            } else {
                cacheProvider = this.cacheService.getDefaultCache();
            }
            Duration timeout = timespan != null ? Duration.ofSeconds(DoubleCaster.cast(timespan * 86400.0).longValue()) : Duration.ofSeconds(0L);
            Duration lastAccessTimeout = idleTime != null ? Duration.ofSeconds(DoubleCaster.cast(idleTime * 86400.0).longValue()) : Duration.ofSeconds(0L);
            switch (cacheAction.ordinal()) {
                case 8: {
                    if (variable == null) {
                        throw new BoxRuntimeException("A variable name is required when specifying the cache action [get]");
                    }
                    result = cacheProvider.getQuiet(cacheKeyName);
                    break;
                }
                case 7: {
                    cacheProvider.set(cacheKeyName, value == null ? this.processCacheBody(context, body) : value, timeout, lastAccessTimeout);
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    result = cacheProvider.getOrSet(cacheKeyName, () -> value == null ? this.processCacheBody(context, body) : value, timeout, lastAccessTimeout);
                    break;
                }
                case 5: {
                    if (key != null) {
                        cacheProvider.clear(key);
                        break;
                    }
                    cacheProvider.clearAll();
                    break;
                }
                case 6: {
                    if (key == null) {
                        throw new BoxRuntimeException("The cache method [delete] was specified but no key was provided for deletion");
                    }
                    cacheProvider.clear(key);
                    break;
                }
                default: {
                    throw new BoxRuntimeException(String.format("The cache action [%s] is unknown or is not implemented in this runtime", cacheAction.toString().toLowerCase()));
                }
            }
        }
        if (result instanceof Attempt) {
            Attempt<Object> castedAttempt = result;
            result = castedAttempt.get();
        }
        if (result instanceof String && attributes.getAsBoolean(Key.stripWhitespace).booleanValue()) {
            result = StringCaster.cast(result).trim();
        }
        if (result instanceof Component.BodyResult && ((Component.BodyResult)result).isEarlyExit()) {
            return (Component.BodyResult)result;
        }
        if (variable != null) {
            ExpressionInterpreter.setVariable(context, variable, result);
        }
        return DEFAULT_RETURN;
    }

    private String processCacheBody(IBoxContext context, Component.ComponentBody body) {
        StringBuffer buffer = new StringBuffer();
        this.processBody(context, body, buffer);
        return buffer.toString();
    }

    public static enum CacheAction {
        CACHE,
        OPTIMAL,
        CONTENT,
        CLIENTCACHE,
        SERVERCACHE,
        FLUSH,
        DELETE,
        PUT,
        GET;


        public static CacheAction fromString(String type) {
            return CacheAction.valueOf(type.trim().toUpperCase());
        }
    }
}

