/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components.debug;

import java.util.Set;
import java.util.UUID;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.BoxComponents;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.ExpressionInterpreter;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.util.Timer;
import ortus.boxlang.runtime.validation.Validator;

@BoxComponents(value={@BoxComponent(name="Timer", allowsBody=true, requiresBody=true), @BoxComponent(name="Stopwatch", allowsBody=true, requiresBody=true)})
public class Timer
extends Component {
    private static ortus.boxlang.runtime.util.Timer timer = new ortus.boxlang.runtime.util.Timer();
    private static final IStruct TIME_UNITS = Struct.of(new Object[]{Key.of("nano"), Timer.TimeUnit.NANOSECONDS, Key.of("micro"), Timer.TimeUnit.MICROSECONDS, Key.of("milli"), Timer.TimeUnit.MILLISECONDS, Key.of("second"), Timer.TimeUnit.SECONDS});

    public Timer() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key.type, "string", Set.of(Validator.valueOneOf("debug", "comment", "inline", "outline"))), new Attribute(Key.label, "string"), new Attribute(Key.unit, "string", "milli", Set.of(Validator.valueOneOf("nano", "micro", "milli", "second"))), new Attribute(Key.variable, "string")};
    }

    @Override
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        String variable = attributes.getAsString(Key.variable);
        Object label = attributes.getAsString(Key.label);
        String precision = attributes.getAsString(Key.unit);
        Key precisionKey = Key.of(precision);
        Timer.TimeUnit unit = (Timer.TimeUnit)((Object)TIME_UNITS.get(precisionKey));
        StringBuffer bodyOutputBuffer = new StringBuffer();
        if (variable != null) {
            long timerResult = timer.timeItRaw(() -> this.processBody(context, body, bodyOutputBuffer), unit);
            ExpressionInterpreter.setVariable(context, variable, timerResult);
        } else if (attributes.getAsString(Key.label) != null && attributes.getAsString(Key.type) == null) {
            String timerResult = timer.timeIt(() -> this.processBody(context, body, bodyOutputBuffer));
            IStruct result = Struct.of(new Object[]{Key.of(attributes.getAsString(Key.label)), timerResult});
            this.runtime.getFunctionService().getGlobalFunction(Key.dump).invoke(context, new Object[]{result}, false, Key.dump);
        } else {
            TimerType type = TimerType.fromString(attributes.getAsString(Key.type));
            String timerResult = timer.timeIt(() -> this.processBody(context, body, bodyOutputBuffer), unit);
            switch (type.ordinal()) {
                case 0: {
                    Object debugInfo;
                    if (label == null) {
                        label = "Timer " + UUID.randomUUID().toString();
                    }
                    if ((debugInfo = ExpressionInterpreter.getVariable(context, "request.debugInfo", true)) == null) {
                        ExpressionInterpreter.setVariable(context, "request.debugInfo", new Struct());
                    }
                    StructCaster.cast(ExpressionInterpreter.getVariable(context, "request.debugInfo", true)).put(Key.of((String)label), (Object)timerResult);
                    context.writeToBuffer(bodyOutputBuffer.toString());
                    break;
                }
                case 1: {
                    context.writeToBuffer(this.toComment((String)label, timerResult, bodyOutputBuffer));
                    break;
                }
                case 2: {
                    context.writeToBuffer(this.toInline((String)label, timerResult, bodyOutputBuffer));
                    break;
                }
                case 3: {
                    context.writeToBuffer(this.toOutline((String)label, timerResult, bodyOutputBuffer));
                }
            }
        }
        return DEFAULT_RETURN;
    }

    private String toComment(String label, String result, StringBuffer outputBuffer) {
        if (label == null) {
            label = "";
        }
        return "<!-- " + label + " : " + result + " -->" + outputBuffer.toString();
    }

    private String toInline(String label, String result, StringBuffer outputBuffer) {
        if (label == null) {
            label = "";
        }
        String labelOutput = label + " : " + result;
        return outputBuffer.toString() + "\n" + labelOutput;
    }

    private String toOutline(String label, String result, StringBuffer outputBuffer) {
        if (label == null) {
            label = "";
        }
        String labelOutput = label + " : " + result;
        return "<fieldset class=\"timer\">" + outputBuffer.toString() + "<legend align=\"top\">" + labelOutput + "</legend></fieldset>";
    }

    private static enum TimerType {
        DEBUG,
        COMMENT,
        INLINE,
        OUTLINE;


        public static TimerType fromString(String type) {
            return TimerType.valueOf(type.trim().toUpperCase());
        }
    }
}

