/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components.io;

import java.util.Map;
import java.util.Set;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.BIFDescriptor;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.ExpressionInterpreter;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.validation.Validator;

@BoxComponent
public class Directory
extends Component {
    private static final Map<Key, BIFDescriptor> actionsMap = Map.of(Key.list, BoxRuntime.getInstance().getFunctionService().getGlobalFunction(Key.directoryList), Key.copy, BoxRuntime.getInstance().getFunctionService().getGlobalFunction(Key.directoryCopy), Key.create, BoxRuntime.getInstance().getFunctionService().getGlobalFunction(Key.directoryCreate), Key.delete, BoxRuntime.getInstance().getFunctionService().getGlobalFunction(Key.directoryDelete), Key.rename, BoxRuntime.getInstance().getFunctionService().getGlobalFunction(Key.directoryMove));

    public Directory() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key.action, "string", "list", Set.of(Validator.REQUIRED, Validator.NON_EMPTY, Validator.valueOneOf("list", "create", "delete", "rename", "copy"))), new Attribute(Key.directory, "string", Set.of(Validator.REQUIRED, Validator.NON_EMPTY)), new Attribute(Key._NAME, "string"), new Attribute(Key.filter, "string", "*"), new Attribute(Key.mode, "string"), new Attribute(Key.sort, "string"), new Attribute(Key.newDirectory, "string"), new Attribute(Key.destination, "string"), new Attribute(Key.recurse, "boolean", false), new Attribute(Key.type, "string", "all", Set.of(Validator.REQUIRED, Validator.NON_EMPTY, Validator.valueOneOf("dir", "file", "all"))), new Attribute(Key.listInfo, "string", "all", Set.of(Validator.REQUIRED, Validator.NON_EMPTY, Validator.valueOneOf("name", "all"))), new Attribute(Key.createPath, "boolean", true)};
    }

    @Override
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        Key action = Key.of(attributes.getAsString(Key.action));
        String directory = attributes.getAsString(Key.directory);
        String name = attributes.getAsString(Key._NAME);
        String filter = attributes.getAsString(Key.filter);
        String mode = attributes.getAsString(Key.mode);
        String sort = attributes.getAsString(Key.sort);
        String newDirectory = attributes.getAsString(Key.newDirectory);
        String destination = attributes.getAsString(Key.destination);
        Boolean recurse = attributes.getAsBoolean(Key.recurse);
        String type = attributes.getAsString(Key.type);
        String listInfo = attributes.getAsString(Key.listInfo);
        Boolean createPath = attributes.getAsBoolean(Key.createPath);
        if (action.equals(Key.list)) {
            this.list(context, directory, name, filter, sort, recurse, type, listInfo);
        } else if (action.equals(Key.create)) {
            this.create(context, directory, createPath, mode);
        } else if (action.equals(Key.delete)) {
            this.delete(context, directory, recurse);
        } else if (action.equals(Key.rename)) {
            this.rename(context, directory, newDirectory, createPath);
        } else if (action.equals(Key.copy)) {
            this.copy(context, directory, destination, recurse, filter, createPath);
        } else {
            throw new BoxRuntimeException("Unimplemeted directory action: " + action.getName());
        }
        return DEFAULT_RETURN;
    }

    private void rename(IBoxContext context, String directory, String newDirectory, Boolean createPath) {
        actionsMap.get(Key.rename).invoke(context, Map.of(Key.oldPath, directory, Key.newPath, newDirectory, Key.createPath, createPath), false, Key.directoryMove);
    }

    private void delete(IBoxContext context, String directory, Boolean recurse) {
        actionsMap.get(Key.delete).invoke(context, Map.of(Key.path, directory, Key.recursive, recurse), false, Key.directoryDelete);
    }

    private void create(IBoxContext context, String directory, Boolean createPath, String mode) {
        IStruct argumentsMap = Struct.of(new Object[]{Key.path, directory, Key.createPath, createPath, Key.ignoreExists, false});
        if (mode != null) {
            argumentsMap.put(Key.mode, mode);
        }
        actionsMap.get(Key.create).invoke(context, argumentsMap, false, Key.directoryCreate);
    }

    private void copy(IBoxContext context, String directory, String newDirectory, Boolean recurse, String filter, Boolean createPath) {
        IStruct argumentsMap = Struct.of(new Object[]{Key.source, directory, Key.destination, newDirectory, Key.recurse, recurse, Key.filter, filter, Key.createPath, createPath});
        actionsMap.get(Key.copy).invoke(context, argumentsMap, false, Key.directoryCopy);
    }

    private void list(IBoxContext context, String directory, String name, String filter, String sort, Boolean recurse, String type, String listInfo) {
        ExpressionInterpreter.setVariable(context, name, actionsMap.get(Key.list).invoke(context, Map.of(Key.path, directory, Key.recurse, recurse, Key.listInfo, listInfo.equalsIgnoreCase("name") ? "querynames" : "query", Key.filter, filter != null ? filter : "", Key.sort, sort != null ? sort : "", Key.type, type), false, Key.directoryList));
    }
}

