/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.IJDBCCapableContext;
import ortus.boxlang.runtime.dynamic.ExpressionInterpreter;
import ortus.boxlang.runtime.jdbc.ConnectionManager;
import ortus.boxlang.runtime.jdbc.DataSource;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.QueryColumnType;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.DatabaseException;
import ortus.boxlang.runtime.validation.Validator;

@BoxComponent(allowsBody=false)
public class DBInfo
extends Component {
    private Logger logger = LoggerFactory.getLogger(DBInfo.class);

    public DBInfo() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key.type, "string", Set.of(Validator.REQUIRED, Validator.NON_EMPTY, Validator.valueOneOf("columns", "dbnames", "tables", "foreignkeys", "index", "procedures", "version"), Validator.valueRequires("columns", Key.table), Validator.valueRequires("foreignkeys", Key.table), Validator.valueRequires("index", Key.table))), new Attribute(Key._NAME, "string", Set.of(Validator.REQUIRED, Validator.NON_EMPTY)), new Attribute(Key.datasource, "string"), new Attribute(Key.table, "string"), new Attribute(Key.pattern, "string"), new Attribute(Key.dbname, "string"), new Attribute(Key.username, "string", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.password, "string", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.filter, "string", Set.of(Validator.NOT_IMPLEMENTED))};
    }

    @Override
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        IJDBCCapableContext jdbcContext = context.getParentOfType(IJDBCCapableContext.class);
        ConnectionManager connectionManager = jdbcContext.getConnectionManager();
        DataSource datasource = attributes.containsKey(Key.datasource) ? connectionManager.getDatasourceOrThrow(Key.of(attributes.getAsString(Key.datasource))) : connectionManager.getDefaultDatasourceOrThrow();
        String tableNameLookup = attributes.getAsString(Key.table);
        if (tableNameLookup == null) {
            tableNameLookup = attributes.getAsString(Key.pattern);
        }
        DBInfoType type = DBInfoType.fromString(attributes.getAsString(Key.type));
        try (Connection conn = datasource.getConnection();){
            DatabaseMetaData databaseMetadata = conn.getMetaData();
            tableNameLookup = this.normalizeTableNameCasing(databaseMetadata, tableNameLookup);
            String databaseName = attributes.getAsString(Key.dbname);
            if (databaseName == null) {
                databaseName = this.parseDatabaseFromTableName(tableNameLookup);
            }
            if (databaseName == null) {
                databaseName = this.getDatabaseNameFromConnection(conn);
            }
            String schema = this.parseSchemaFromTableName(tableNameLookup);
            String tableName = this.parseTableName(tableNameLookup);
            Query result = switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> this.getDbNames(databaseMetadata);
                case 6 -> this.getVersion(databaseMetadata);
                case 0 -> this.getColumnsForTable(databaseMetadata, databaseName, schema, tableName);
                case 2 -> this.getTables(databaseMetadata, databaseName, schema, tableName);
                case 3 -> this.getForeignKeys(databaseMetadata, databaseName, schema, tableName);
                case 4 -> this.getIndexes(databaseMetadata, databaseName, schema, tableName);
                case 5 -> this.getProcedures(databaseMetadata, databaseName, schema, tableName);
            };
            ExpressionInterpreter.setVariable(context, attributes.getAsString(Key._NAME), result);
        }
        catch (SQLException e) {
            throw new DatabaseException("Unable to read " + attributes.getAsString(Key.type) + " metadata", e);
        }
        return DEFAULT_RETURN;
    }

    private Query getDbNames(DatabaseMetaData databaseMetadata) throws SQLException {
        Query result = new Query();
        result.addColumn(Key.of("DBNAME"), QueryColumnType.VARCHAR);
        result.addColumn(Key.of("type"), QueryColumnType.VARCHAR);
        try (ResultSet catalogs = databaseMetadata.getCatalogs();){
            while (catalogs.next()) {
                result.addRow(new Object[]{catalogs.getObject(1), "CATALOG"});
            }
        }
        try (ResultSet schemas = databaseMetadata.getSchemas();){
            while (schemas.next()) {
                result.addRow(new Object[]{schemas.getObject(1), "SCHEMA"});
            }
        }
        return result;
    }

    private Query getVersion(DatabaseMetaData databaseMetadata) throws SQLException {
        Query result = new Query();
        result.addColumn(Key.of("DATABASE_PRODUCTNAME"), QueryColumnType.VARCHAR, new Object[]{databaseMetadata.getDatabaseProductName()});
        result.addColumn(Key.of("DATABASE_VERSION"), QueryColumnType.VARCHAR, new Object[]{databaseMetadata.getDatabaseProductVersion()});
        result.addColumn(Key.of("DRIVER_NAME"), QueryColumnType.VARCHAR, new Object[]{databaseMetadata.getDriverName()});
        result.addColumn(Key.of("DRIVER_VERSION"), QueryColumnType.VARCHAR, new Object[]{databaseMetadata.getDriverVersion()});
        result.addColumn(Key.of("JDBC_MAJOR_VERSION"), QueryColumnType.VARCHAR, new Object[]{(double)databaseMetadata.getJDBCMajorVersion()});
        result.addColumn(Key.of("JDBC_MINOR_VERSION"), QueryColumnType.DOUBLE, new Object[]{(double)databaseMetadata.getJDBCMinorVersion()});
        return result;
    }

    private Query getColumnsForTable(DatabaseMetaData databaseMetadata, String databaseName, String schema, String tableName) throws SQLException {
        Query result = new Query();
        try (ResultSet resultSet = databaseMetadata.getColumns(databaseName, schema, tableName, null);){
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.buildQueryColumns(result, resultSetMetaData);
            result.addColumn(Key.of("IS_PRIMARYKEY"), QueryColumnType.BIT);
            result.addColumn(Key.of("IS_FOREIGNKEY"), QueryColumnType.BIT);
            result.addColumn(Key.of("REFERENCED_PRIMARYKEY"), QueryColumnType.VARCHAR);
            result.addColumn(Key.of("REFERENCED_PRIMARYKEY_TABLE"), QueryColumnType.VARCHAR);
            HashMap<String, List> primaryKeyCache = new HashMap<String, List>();
            HashMap<String, Map> foreignKeyCache = new HashMap<String, Map>();
            while (resultSet.next()) {
                IStruct row = this.buildQueryRow(resultSet, resultSetMetaData);
                String columnCatalog = resultSet.getString("TABLE_CAT") == null ? "" : resultSet.getString("TABLE_CAT");
                String columnSchema = resultSet.getString("TABLE_SCHEM") == null ? "" : resultSet.getString("TABLE_SCHEM");
                String columnTable = resultSet.getString("TABLE_NAME");
                String lookupHash = String.format("%d.%d.%d", columnCatalog.hashCode(), columnSchema.hashCode(), columnTable.hashCode());
                List primaryKeys = primaryKeyCache.computeIfAbsent(lookupHash, k -> this.getPrimaryKeys(databaseMetadata, columnCatalog, columnSchema, columnTable));
                Map foreignKeys = foreignKeyCache.computeIfAbsent(lookupHash, k -> this.getForeignKeysAsMap(databaseMetadata, columnCatalog, columnSchema, columnTable));
                boolean isPrimaryKey = primaryKeys.contains(row.getAsString(Key.of("COLUMN_NAME")));
                boolean isForeignKey = foreignKeys.containsKey(row.getAsString(Key.of("COLUMN_NAME")));
                String referencedKeyColumn = "N/A";
                String referencedKeyTable = "N/A";
                if (isForeignKey) {
                    Map fkey = (Map)foreignKeys.get(row.getAsString(Key.of("COLUMN_NAME")));
                    referencedKeyColumn = (String)fkey.get("PKCOLUMN_NAME");
                    referencedKeyTable = (String)fkey.get("PKTABLE_NAME");
                }
                row.put(Key.of("IS_PRIMARYKEY"), (Object)isPrimaryKey);
                row.put(Key.of("IS_FOREIGNKEY"), (Object)isForeignKey);
                row.put(Key.of("REFERENCED_PRIMARYKEY"), (Object)referencedKeyColumn);
                row.put(Key.of("REFERENCED_PRIMARYKEY_TABLE"), (Object)referencedKeyTable);
                result.addRow(row);
            }
            if (result.isEmpty() && !databaseMetadata.getTables(null, schema, tableName, null).next()) {
                throw new DatabaseException(String.format("Table not found for pattern [%s] on schema [%s]", tableName, schema));
            }
        }
        return result;
    }

    private Query getTables(DatabaseMetaData databaseMetadata, String databaseName, String schema, String tableName) throws SQLException {
        Query result = new Query();
        try (ResultSet resultSet = databaseMetadata.getTables(databaseName, schema, tableName, null);){
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.buildQueryColumns(result, resultSetMetaData);
            while (resultSet.next()) {
                IStruct row = this.buildQueryRow(resultSet, resultSetMetaData);
                result.addRow(row);
            }
        }
        return result;
    }

    private Query getForeignKeys(DatabaseMetaData databaseMetadata, String databaseName, String schema, String tableName) throws SQLException {
        Query result = new Query();
        try (ResultSet resultSet = databaseMetadata.getExportedKeys(databaseName, schema, tableName);){
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.buildQueryColumns(result, resultSetMetaData);
            while (resultSet.next()) {
                IStruct row = this.buildQueryRow(resultSet, resultSetMetaData);
                result.addRow(row);
            }
            if (result.isEmpty() && !databaseMetadata.getTables(null, schema, tableName, null).next()) {
                throw new DatabaseException(String.format("Table not found for pattern [%s] on schema [%s]", tableName, schema));
            }
        }
        return result;
    }

    private Query getIndexes(DatabaseMetaData databaseMetadata, String databaseName, String schema, String tableName) throws SQLException {
        Query result = new Query();
        try (ResultSet resultSet = databaseMetadata.getIndexInfo(databaseName, schema, tableName, false, true);){
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.buildQueryColumns(result, resultSetMetaData);
            while (resultSet.next()) {
                IStruct row = this.buildQueryRow(resultSet, resultSetMetaData);
                Integer indexType = row.getAsInteger(Key.type);
                String stringIndexType = switch (indexType) {
                    case 0 -> "Table Statistic";
                    case 1 -> "Clustered Index";
                    case 2 -> "Hashed Index";
                    case 3 -> "Other Index";
                    default -> row.getAsString(Key.type);
                };
                row.put(Key.type, (Object)stringIndexType);
                result.addRow(row);
            }
            if (result.isEmpty() && !databaseMetadata.getTables(null, schema, tableName, null).next()) {
                throw new DatabaseException(String.format("Table not found for pattern [%s] on schema [%s]", tableName, schema));
            }
        }
        return result;
    }

    private Query getProcedures(DatabaseMetaData databaseMetadata, String databaseName, String schema, String tableName) throws SQLException {
        Query result = new Query();
        try (ResultSet resultSet = databaseMetadata.getProcedures(databaseName, schema, tableName);){
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.buildQueryColumns(result, resultSetMetaData);
            while (resultSet.next()) {
                IStruct row = this.buildQueryRow(resultSet, resultSetMetaData);
                result.addRow(row);
            }
        }
        return result;
    }

    private IStruct buildQueryRow(ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws SQLException {
        int columnCount = resultSetMetaData.getColumnCount();
        Struct row = new Struct(IStruct.TYPES.LINKED);
        for (int i = 1; i <= columnCount; ++i) {
            row.put(Key.of(resultSetMetaData.getColumnLabel(i)), resultSet.getObject(i));
        }
        return row;
    }

    private void buildQueryColumns(Query result, ResultSetMetaData resultSetMetaData) throws SQLException {
        int columnCount = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            result.addColumn(Key.of(resultSetMetaData.getColumnLabel(i)), QueryColumnType.fromSQLType(resultSetMetaData.getColumnType(i)));
        }
    }

    private String parseDatabaseFromTableName(String tableName) {
        if (tableName != null && tableName.contains(".")) {
            String[] parts2 = tableName.split("\\.");
            return parts2.length == 3 ? parts2[0] : null;
        }
        return null;
    }

    private String parseTableName(String tableName) {
        if (tableName != null && tableName.contains(".")) {
            return tableName.substring(tableName.lastIndexOf(46) + 1);
        }
        return tableName;
    }

    private String parseSchemaFromTableName(String tableName) {
        if (tableName != null && tableName.contains(".")) {
            String[] parts2 = tableName.split("\\.");
            return parts2.length == 3 ? parts2[1] : parts2[0];
        }
        return null;
    }

    private String normalizeTableNameCasing(DatabaseMetaData metaData, String tableOrSchema) throws SQLException {
        if (tableOrSchema == null) {
            return null;
        }
        if (metaData.storesLowerCaseIdentifiers()) {
            return tableOrSchema.toLowerCase();
        }
        if (metaData.storesUpperCaseIdentifiers()) {
            return tableOrSchema.toUpperCase();
        }
        return tableOrSchema;
    }

    private List<String> getPrimaryKeys(DatabaseMetaData metadata, String catalog, String schema, String table) {
        ArrayList<String> temp = new ArrayList<String>();
        try (ResultSet keys = metadata.getPrimaryKeys(catalog, schema, table);){
            while (keys.next()) {
                temp.add(keys.getString("COLUMN_NAME"));
            }
        }
        catch (SQLException e) {
            this.logger.error("Unable to read foreign key info for table [{}], schema [{}], and catalog [{}]", table, schema, catalog, e);
            throw new BoxRuntimeException("Unable to read foreign key info", e);
        }
        return temp;
    }

    private Map<String, Map<String, String>> getForeignKeysAsMap(DatabaseMetaData metadata, String catalog, String schema, String table) {
        HashMap<String, Map<String, String>> temp = new HashMap<String, Map<String, String>>();
        try (ResultSet keys = metadata.getImportedKeys(catalog, schema, table);){
            while (keys.next()) {
                temp.put(keys.getString("FKCOLUMN_NAME"), Map.of("PKCOLUMN_NAME", keys.getString("PKCOLUMN_NAME"), "PKTABLE_NAME", keys.getString("PKTABLE_NAME")));
            }
        }
        catch (SQLException e) {
            this.logger.error("Unable to read foreign key info for table [{}], schema [{}], and catalog [{}]", table, schema, catalog, e);
            throw new BoxRuntimeException("Unable to read foreign key info", e);
        }
        return temp;
    }

    private String getDatabaseNameFromConnection(Connection conn) {
        try {
            return conn.getCatalog();
        }
        catch (SQLException e) {
            this.logger.warn("Unable to read database name from connection", e);
            return null;
        }
    }

    private static enum DBInfoType {
        COLUMNS,
        DBNAMES,
        TABLES,
        FOREIGNKEYS,
        INDEX,
        PROCEDURES,
        VERSION;


        public static DBInfoType fromString(String type) {
            return DBInfoType.valueOf(type.trim().toUpperCase());
        }
    }
}

