/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components.jdbc;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.IJDBCCapableContext;
import ortus.boxlang.runtime.dynamic.ExpressionInterpreter;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.jdbc.ConnectionManager;
import ortus.boxlang.runtime.jdbc.ExecutedQuery;
import ortus.boxlang.runtime.jdbc.PendingQuery;
import ortus.boxlang.runtime.jdbc.QueryOptions;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.validation.Validator;

@BoxComponent(requiresBody=true)
public class Query
extends Component {
    private Logger log = LoggerFactory.getLogger(Query.class);

    public Query() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key._NAME, "string"), new Attribute(Key.datasource, "string"), new Attribute(Key.returnType, "string", "query", Set.of(Validator.valueRequires("struct", Key.columnKey))), new Attribute(Key.columnKey, "string"), new Attribute(Key.maxRows, "integer", -1), new Attribute(Key.blockfactor, "integer", Set.of(Validator.min(1), Validator.max(100)), Set.of()), new Attribute(Key.fetchSize, "integer", Set.of(Validator.min(1), Validator.max(100))), new Attribute(Key.timeout, "integer"), new Attribute(Key.cache, "boolean", false), new Attribute(Key.cacheTimeout, "duration"), new Attribute(Key.cacheLastAccessTimeout, "duration"), new Attribute(Key.cacheKey, "string"), new Attribute(Key.cacheProvider, "string"), new Attribute(Key.timezone, "string", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.dbtype, "string", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.username, "string", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.password, "string", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.debug, "boolean", false, Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.result, "string"), new Attribute(Key.ormoptions, "struct", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.clientInfo, "struct", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.fetchClientInfo, "boolean", false, Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.lazy, "boolean", false, Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.psq, "boolean", false, Set.of(Validator.NOT_IMPLEMENTED))};
    }

    @Override
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        IJDBCCapableContext jdbcContext = context.getParentOfType(IJDBCCapableContext.class);
        ConnectionManager connectionManager = jdbcContext.getConnectionManager();
        QueryOptions options = new QueryOptions(attributes);
        executionState.put(Key.queryParams, (Object)new Array());
        StringBuffer buffer = new StringBuffer();
        context.pushComponent(Struct.of(new Object[]{Key._NAME, Key.output, Key._CLASS, null, Key.attributes, Struct.EMPTY}));
        Component.BodyResult bodyResult = this.processBody(context, body, buffer);
        context.popComponent();
        if (bodyResult.isEarlyExit()) {
            return bodyResult;
        }
        String sql = buffer.toString();
        Array bindings = executionState.getAsArray(Key.queryParams);
        PendingQuery pendingQuery = new PendingQuery(sql, bindings, options);
        ExecutedQuery executedQuery = pendingQuery.execute(connectionManager);
        if (options.wantsResultStruct()) {
            assert (options.resultVariableName != null);
            ExpressionInterpreter.setVariable(context, options.resultVariableName, executedQuery.getResults().getMetaData());
        }
        String variableName = StringCaster.cast(attributes.getOrDefault(Key._NAME, (Object)"bxquery"));
        ExpressionInterpreter.setVariable(context, variableName, options.castAsReturnType(executedQuery));
        return DEFAULT_RETURN;
    }
}

