/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.IJDBCCapableContext;
import ortus.boxlang.runtime.dynamic.ExpressionInterpreter;
import ortus.boxlang.runtime.dynamic.casters.IntegerCaster;
import ortus.boxlang.runtime.jdbc.ConnectionManager;
import ortus.boxlang.runtime.jdbc.QueryOptions;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.QueryColumnType;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.DatabaseException;
import ortus.boxlang.runtime.validation.Validator;

@BoxComponent(requiresBody=true)
public class StoredProc
extends Component {
    public StoredProc() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key.procedure, "string", Set.of(Validator.REQUIRED, Validator.NON_EMPTY)), new Attribute(Key.datasource, "string"), new Attribute(Key.username, "string", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.password, "string", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.blockfactor, "integer", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.debug, "boolean", false, Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.returnCode, "boolean", false, Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.result, "string", Set.of(Validator.NOT_IMPLEMENTED))};
    }

    @Override
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        IJDBCCapableContext jdbcContext = context.getParentOfType(IJDBCCapableContext.class);
        ConnectionManager connectionManager = jdbcContext.getConnectionManager();
        QueryOptions options = new QueryOptions(attributes);
        Array params = new Array();
        Array procResults = new Array();
        executionState.put(Key.queryParams, (Object)params);
        executionState.put(Key.procResult, (Object)procResults);
        Component.BodyResult bodyResult = this.processBody(context, body, null);
        if (bodyResult.isEarlyExit()) {
            return bodyResult;
        }
        String callString = this.buildCallString(attributes.getAsString(Key.procedure), params);
        try (Connection conn = connectionManager.getConnection(options);
             CallableStatement procedure = conn.prepareCall(callString);){
            this.registerProcedureParams(procedure, params);
            if (options.maxRows > 0L) {
                procedure.setLargeMaxRows(options.maxRows);
            }
            procedure.execute();
            this.putOutVariablesInContext(context, procedure, params);
            this.putResultSetsInContext(context, procedure, procResults);
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return DEFAULT_RETURN;
    }

    private String buildCallString(String procedureName, Array params) {
        String paramString = params.stream().map(x -> "?").collect(Collectors.joining(", "));
        return "{call " + procedureName + "(" + paramString + ")}";
    }

    private void registerProcedureParams(CallableStatement procedure, Array params) throws SQLException {
        for (int i = 0; i < params.size(); ++i) {
            IStruct attr = (IStruct)params.get(i);
            if (attr.containsKey(Key.type) && attr.getAsString(Key.type).toLowerCase().contains("in")) {
                procedure.setObject(i + 1, attr.get(Key.value), QueryColumnType.fromString((String)attr.getAsString((Key)Key.sqltype)).sqlType);
            }
            if (!attr.containsKey(Key.type) || !attr.getAsString(Key.type).toLowerCase().contains("out")) continue;
            procedure.registerOutParameter(i + 1, QueryColumnType.fromString((String)attr.getAsString((Key)Key.sqltype)).sqlType);
        }
    }

    private void putResultSetsInContext(IBoxContext context, CallableStatement procedure, Array procResults) throws SQLException {
        if (procResults.size() == 1) {
            IStruct resultSetAttr = (IStruct)procResults.get(0);
            ExpressionInterpreter.setVariable(context, resultSetAttr.getAsString(Key._name), Query.fromResultSet(procedure.getResultSet()));
            return;
        }
        this.validateProcResultResultSetAttribute(procResults);
        ResultSet res = procedure.getResultSet();
        int index = 1;
        while (res != null) {
            int _index = index++;
            Optional<Object> resultSetAttr = procResults.stream().filter(pr -> {
                IStruct attr = (IStruct)pr;
                return attr.containsKey(Key.resultSet) && IntegerCaster.cast(attr.get(Key.resultSet)) == _index;
            }).findFirst();
            ResultSet currentRes = res;
            resultSetAttr.ifPresent(attr -> ExpressionInterpreter.setVariable(context, ((IStruct)attr).getAsString(Key._name), Query.fromResultSet(currentRes)));
            if (!procedure.getMoreResults()) break;
            res = procedure.getResultSet();
        }
    }

    private void validateProcResultResultSetAttribute(Array procResults) {
        boolean allHaveIndex = procResults.stream().allMatch(pr -> {
            IStruct resultSetAttr = (IStruct)pr;
            return resultSetAttr.containsKey(Key.resultSet);
        });
        if (allHaveIndex) {
            return;
        }
        throw new BoxRuntimeException("If there is more than one ProcResult component they must all have a resultSet attribute");
    }

    private void putOutVariablesInContext(IBoxContext context, CallableStatement procedure, Array params) throws SQLException {
        for (int i = 0; i < params.size(); ++i) {
            IStruct attr = (IStruct)params.get(i);
            if (!attr.containsKey(Key.type) || !attr.getAsString(Key.type).toLowerCase().contains("out")) continue;
            ExpressionInterpreter.setVariable(context, attr.getAsString(Key.variable), procedure.getObject(i + 1));
        }
    }
}

