/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components.jdbc;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.IJDBCCapableContext;
import ortus.boxlang.runtime.jdbc.ConnectionManager;
import ortus.boxlang.runtime.jdbc.DataSource;
import ortus.boxlang.runtime.jdbc.ITransaction;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.DatabaseException;
import ortus.boxlang.runtime.validation.Validator;

@BoxComponent(allowsBody=true)
public class Transaction
extends Component {
    private Logger log = LoggerFactory.getLogger(Transaction.class);

    public Transaction() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key.action, "string", "begin", Set.of(Validator.valueOneOf("begin", "commit", "rollback", "setsavepoint"))), new Attribute(Key.isolation, "string", Set.of(Validator.valueOneOf("read_uncommitted", "read_committed", "repeatable_read", "serializable"))), new Attribute(Key.savepoint, "string"), new Attribute(Key.nested, "boolean", false, Set.of(Validator.TYPE)), new Attribute(Key.datasource, "string")};
    }

    @Override
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        ITransaction transaction;
        boolean isTransactionBeginning = attributes.getAsString(Key.action).equals("begin") || body != null;
        IJDBCCapableContext jdbcContext = context.getParentOfType(IJDBCCapableContext.class);
        ConnectionManager connectionManager = jdbcContext.getConnectionManager();
        if (isTransactionBeginning) {
            Object dataSource;
            Object object = dataSource = attributes.containsKey(Key.datasource) ? connectionManager.getDatasource(Key.of(attributes.getAsString(Key.datasource))) : connectionManager.getDefaultDatasource();
            if (dataSource != null) {
                // empty if block
            }
            transaction = connectionManager.beginTransaction((DataSource)dataSource);
            if (attributes.containsKey(Key.isolation)) {
                transaction.setIsolationLevel(this.getIsolationLevel(attributes.getAsString(Key.isolation)));
            }
        } else {
            transaction = connectionManager.getTransactionOrThrow();
        }
        if (body == null) {
            switch (attributes.getAsString(Key.action)) {
                case "begin": {
                    transaction.begin();
                    break;
                }
                case "end": {
                    connectionManager.endTransaction();
                    break;
                }
                case "commit": {
                    transaction.commit();
                    break;
                }
                case "rollback": {
                    transaction.rollback(Key.of(attributes.getAsString(Key.savepoint)));
                    break;
                }
                case "setsavepoint": {
                    transaction.setSavepoint(Key.of(attributes.getAsString(Key.savepoint)));
                    break;
                }
                default: {
                    throw new BoxRuntimeException("Unknown action: " + attributes.getAsString(Key.action));
                }
            }
        } else {
            transaction.begin();
            Component.BodyResult bodyResult = null;
            try {
                bodyResult = this.processBody(context, body);
                transaction.commit();
            }
            catch (DatabaseException e) {
                this.log.error("Encountered generic exception while processing transaction; rolling back", e);
                transaction.rollback();
                throw new DatabaseException(e.getMessage(), e);
            }
            catch (Throwable e) {
                this.log.error("Encountered database exception while processing transaction; rolling back", e);
                transaction.rollback();
                throw new BoxRuntimeException(e.getMessage(), e);
            }
            finally {
                connectionManager.endTransaction();
            }
            return bodyResult == null ? DEFAULT_RETURN : bodyResult;
        }
        return DEFAULT_RETURN;
    }

    private int getIsolationLevel(String isolationLevel) {
        switch (isolationLevel) {
            case "read_uncommitted": {
                return 1;
            }
            case "read_committed": {
                return 2;
            }
            case "repeatable_read": {
                return 4;
            }
            case "serializable": {
                return 8;
            }
        }
        throw new BoxRuntimeException("Unsupported isolation level: " + isolationLevel);
    }
}

