/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components.net;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.ExpressionInterpreter;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.DoubleCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.net.HTTPStatusReasons;
import ortus.boxlang.runtime.net.HttpManager;
import ortus.boxlang.runtime.net.HttpRequestMultipartBody;
import ortus.boxlang.runtime.net.URIBuilder;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.QueryColumnType;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.util.FileSystemUtil;
import ortus.boxlang.runtime.util.ResolvedFilePath;
import ortus.boxlang.runtime.validation.Validator;

@BoxComponent(allowsBody=true)
public class HTTP
extends Component {
    public HTTP() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key.URL, "string", Set.of(Validator.REQUIRED, Validator.NON_EMPTY, (cxt, comp, attr, attrs) -> {
            if (!attrs.getAsString(attr.name()).startsWith("http")) {
                throw new BoxValidationException(comp, attr, "must start with 'http://' or 'https://'");
            }
        })), new Attribute(Key.port, "numeric"), new Attribute(Key.method, "string", "GET", Set.of(Validator.REQUIRED, Validator.NON_EMPTY, Validator.valueOneOf("GET", "POST", "PUT", "DELETE", "HEAD", "TRACE", "OPTIONS", "PATCH"))), new Attribute(Key.proxyServer, "string"), new Attribute(Key.proxyPort, "string"), new Attribute(Key.proxyUser, "string"), new Attribute(Key.proxyPassword, "string"), new Attribute(Key.username, "string"), new Attribute(Key.password, "string"), new Attribute(Key.userAgent, "string", "BoxLang"), new Attribute(Key.charset, "string", "UTF-8"), new Attribute(Key.resolveUrl, "boolean", false), new Attribute(Key.throwOnError, "boolean", true), new Attribute(Key.redirect, "boolean", true), new Attribute(Key.timeout, "numeric", Set.of(Validator.min(1))), new Attribute(Key.getAsBinary, "string", "auto", Set.of(Validator.REQUIRED, Validator.NON_EMPTY, Validator.valueOneOf("auto", "no", "yes", "never"))), new Attribute(Key.result, "string", "bxhttp", Set.of(Validator.REQUIRED, Validator.NON_EMPTY)), new Attribute(Key.delimiter, "string", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key._NAME, "string", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.columns, "string", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.firstRowAsHeaders, "boolean", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.textQualifier, "string", Set.of(Validator.NOT_IMPLEMENTED)), new Attribute(Key.file, "string", Set.of(Validator.requires(Key.path))), new Attribute(Key.multipart, "boolean", false, Set.of(Validator.TYPE)), new Attribute(Key.multipartType, "string", "form-data", Set.of(Validator.REQUIRED, Validator.NON_EMPTY, Validator.valueOneOf("form-data", "related"))), new Attribute(Key.clientCertPassword, "string"), new Attribute(Key.path, "string", Set.of(Validator.requires(Key.file))), new Attribute(Key.clientCert, "string"), new Attribute(Key.compression, "string"), new Attribute(Key.authType, "string", "BASIC", Set.of(Validator.REQUIRED, Validator.NON_EMPTY, Validator.valueOneOf("BASIC", "NTLM"))), new Attribute(Key.domain, "string"), new Attribute(Key.workstation, "string"), new Attribute(Key.cachedWithin, "string"), new Attribute(Key.encodeUrl, "boolean", true, Set.of(Validator.TYPE))};
    }

    @Override
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        executionState.put(Key.HTTPParams, (Object)new Array());
        Component.BodyResult bodyResult = this.processBody(context, body);
        if (bodyResult.isEarlyExit()) {
            return bodyResult;
        }
        String variableName = StringCaster.cast(attributes.getOrDefault(Key.result, (Object)"bxhttp"));
        String theURL = attributes.getAsString(Key.URL);
        String method = StringCaster.cast(attributes.getOrDefault(Key.method, (Object)"GET")).toUpperCase();
        Array params = executionState.getAsArray(Key.HTTPParams);
        Struct HTTPResult = new Struct();
        URI uri = null;
        try {
            CompletableFuture<HttpResponse<String>> inflightRequest;
            HttpRequest.Builder builder = HttpRequest.newBuilder();
            URIBuilder uriBuilder = new URIBuilder(theURL);
            Object bodyPublisher = null;
            ArrayList<IStruct> formFields = new ArrayList<IStruct>();
            ArrayList<IStruct> files = new ArrayList<IStruct>();
            builder.header("User-Agent", "BoxLang");
            block23: for (Iterator p : params) {
                IStruct param = StructCaster.cast(p);
                String type = param.getAsString(Key.type);
                switch (type.toLowerCase()) {
                    case "header": {
                        builder.header(param.getAsString(Key._NAME), param.getAsString(Key.value));
                        continue block23;
                    }
                    case "body": {
                        if (bodyPublisher != null) {
                            throw new BoxRuntimeException("Cannot use a body httpparam with an existing http body: " + bodyPublisher.toString());
                        }
                        bodyPublisher = HttpRequest.BodyPublishers.ofString(param.getAsString(Key.value));
                        continue block23;
                    }
                    case "xml": {
                        if (bodyPublisher != null) {
                            throw new BoxRuntimeException("Cannot use a xml httpparam with an existing http body: " + bodyPublisher.toString());
                        }
                        builder.header("Content-Type", "text/xml");
                        bodyPublisher = HttpRequest.BodyPublishers.ofString(param.getAsString(Key.value));
                        continue block23;
                    }
                    case "cgi": {
                        builder.header(param.getAsString(Key._NAME), URLEncoder.encode(param.getAsString(Key.value), StandardCharsets.UTF_8));
                        continue block23;
                    }
                    case "file": {
                        files.add(param);
                        continue block23;
                    }
                    case "url": {
                        uriBuilder.addParameter(param.getAsString(Key._NAME), BooleanCaster.cast(param.getOrDefault(Key.encoded, (Object)true)) != false ? URLEncoder.encode(StringCaster.cast(param.get(Key.value)), StandardCharsets.UTF_8) : StringCaster.cast(param.get(Key.value)));
                        continue block23;
                    }
                    case "formfield": {
                        formFields.add(param);
                        continue block23;
                    }
                    case "cookie": {
                        builder.header("Cookie", param.getAsString(Key._NAME) + "=" + URLEncoder.encode(param.getAsString(Key.value), StandardCharsets.UTF_8));
                        continue block23;
                    }
                }
                throw new BoxRuntimeException("Unhandled HTTPParam type: " + type);
            }
            if (!files.isEmpty()) {
                if (bodyPublisher != null) {
                    throw new BoxRuntimeException("Cannot use a multipart body with an existing http body: " + bodyPublisher.toString());
                }
                HttpRequestMultipartBody.Builder multipartBodyBuilder = new HttpRequestMultipartBody.Builder();
                for (IStruct param : files) {
                    ResolvedFilePath path = FileSystemUtil.expandPath(context, param.getAsString(Key.file));
                    File file = path.absolutePath().toFile();
                    String mimeType = Optional.ofNullable(param.getAsString(Key.mimetype)).orElseGet(() -> URLConnection.getFileNameMap().getContentTypeFor(file.getName()));
                    multipartBodyBuilder.addPart(param.getAsString(Key._name), file, mimeType, file.getName());
                }
                for (IStruct formField2 : formFields) {
                    multipartBodyBuilder.addPart(formField2.getAsString(Key._name), formField2.getAsString(Key.value));
                }
                HttpRequestMultipartBody multipartBody = multipartBodyBuilder.build();
                builder.header("Content-Type", multipartBody.getContentType());
                bodyPublisher = HttpRequest.BodyPublishers.ofByteArray(multipartBody.getBody());
            } else if (!formFields.isEmpty()) {
                if (bodyPublisher != null) {
                    throw new BoxRuntimeException("Cannot use a formfield httpparam with an existing http body: " + bodyPublisher.toString());
                }
                bodyPublisher = HttpRequest.BodyPublishers.ofString(formFields.stream().map(formField -> {
                    String value = formField.getAsString(Key.value);
                    if (BooleanCaster.cast(formField.getOrDefault(Key.encoded, (Object)true)).booleanValue()) {
                        value = URLEncoder.encode(value, StandardCharsets.UTF_8);
                    }
                    return formField.getAsString(Key._name) + "=" + value;
                }).collect(Collectors.joining("&")));
                builder.header("Content-Type", "application/x-www-form-urlencoded");
            }
            if (bodyPublisher == null) {
                bodyPublisher = HttpRequest.BodyPublishers.noBody();
            }
            builder.method(method, (HttpRequest.BodyPublisher)bodyPublisher);
            uri = uriBuilder.build();
            builder.uri(uri);
            HttpRequest request = builder.build();
            HttpClient client = HttpManager.getClient();
            CompletionStage<HttpResponse<String>> winner = inflightRequest = client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
            if (attributes.containsKey(Key.timeout)) {
                winner = inflightRequest.applyToEither(HttpManager.getTimeoutRequestAsync(attributes.getAsInteger(Key.timeout)), result -> result);
            }
            HttpResponse<String> response = winner.get();
            HttpHeaders httpHeaders = Optional.ofNullable(response.headers()).orElse(HttpHeaders.of(Map.of(), (a, b) -> true));
            IStruct headers = this.transformToResponseHeaderStruct(httpHeaders.map());
            String httpVersionString = response.version() == HttpClient.Version.HTTP_1_1 ? "HTTP/1.1" : "HTTP/2";
            String statusCodeString = String.valueOf(response.statusCode());
            String statusText = HTTPStatusReasons.getReasonForStatus(response.statusCode());
            headers.put(Key.HTTP_Version, (Object)httpVersionString);
            headers.put(Key.status_code, (Object)statusCodeString);
            headers.put(Key.explanation, (Object)statusText);
            HTTPResult.put(Key.responseHeader, (Object)headers);
            HTTPResult.put(Key.header, (Object)this.generateHeaderString(this.generateStatusLine(httpVersionString, statusCodeString, statusText), headers));
            HTTPResult.put(Key.HTTP_Version, (Object)httpVersionString);
            HTTPResult.put(Key.statusCode, (Object)response.statusCode());
            HTTPResult.put(Key.status_code, (Object)response.statusCode());
            HTTPResult.put(Key.statusText, (Object)statusText);
            HTTPResult.put(Key.status_text, (Object)statusText);
            HTTPResult.put(Key.fileContent, (Object)(response.statusCode() == 408 ? "Request Timeout" : response.body()));
            HTTPResult.put(Key.errorDetail, (Object)(response.statusCode() == 408 ? response.body() : ""));
            Optional<String> contentTypeHeader = httpHeaders.firstValue("Content-Type");
            contentTypeHeader.ifPresent(contentType -> {
                String[] contentTypeParts = contentType.split("; *");
                if (contentTypeParts.length > 0) {
                    HTTPResult.put(Key.mimetype, (Object)contentTypeParts[0]);
                }
                if (contentTypeParts.length > 1) {
                    String charset = contentTypeParts[1].replace("charset=", "");
                    HTTPResult.put(Key.charset, (Object)charset);
                }
            });
            HTTPResult.put(Key.cookies, (Object)this.generateCookiesQuery(headers));
            ExpressionInterpreter.setVariable(context, variableName, HTTPResult);
            return DEFAULT_RETURN;
        }
        catch (ExecutionException e) {
            Throwable innerException = e.getCause();
            if (innerException instanceof ConnectException) {
                HTTPResult.put(Key.responseHeader, (Object)Struct.EMPTY);
                HTTPResult.put(Key.header, (Object)"");
                HTTPResult.put(Key.statusCode, (Object)502);
                HTTPResult.put(Key.status_code, (Object)502);
                HTTPResult.put(Key.statusText, (Object)"Bad Gateway");
                HTTPResult.put(Key.status_text, (Object)"Bad Gateway");
                HTTPResult.put(Key.fileContent, (Object)"Connection Failure");
                if (uri != null) {
                    HTTPResult.put(Key.errorDetail, (Object)String.format("Unknown host: %s: Name or service not known.", uri.getHost()));
                } else {
                    HTTPResult.put(Key.errorDetail, (Object)String.format("Unknown host: %s: Name or service not known.", theURL));
                }
            } else {
                throw new BoxRuntimeException(innerException.getMessage());
            }
            ExpressionInterpreter.setVariable(context, variableName, HTTPResult);
            return DEFAULT_RETURN;
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new BoxRuntimeException(e.getMessage(), e);
        }
    }

    private Query generateCookiesQuery(IStruct headers) {
        Query cookies = new Query();
        cookies.addColumn(Key._NAME, QueryColumnType.VARCHAR);
        cookies.addColumn(Key.value, QueryColumnType.VARCHAR);
        cookies.addColumn(Key.path, QueryColumnType.VARCHAR);
        cookies.addColumn(Key.domain, QueryColumnType.VARCHAR);
        cookies.addColumn(Key.expires, QueryColumnType.VARCHAR);
        cookies.addColumn(Key.secure, QueryColumnType.VARCHAR);
        cookies.addColumn(Key.httpOnly, QueryColumnType.VARCHAR);
        cookies.addColumn(Key.samesite, QueryColumnType.VARCHAR);
        Object cookieValue = headers.getOrDefault(Key.of("Set-Cookie"), (Object)new Array());
        CastAttempt<Array> isValuesArray = ArrayCaster.attempt(cookieValue);
        if (isValuesArray.wasSuccessful()) {
            Array values = (Array)isValuesArray.getOrFail();
            for (Object value : values) {
                this.parseCookieStringIntoQuery(StringCaster.cast(value), cookies);
            }
        } else {
            this.parseCookieStringIntoQuery(StringCaster.cast(cookieValue), cookies);
        }
        return cookies;
    }

    private void parseCookieStringIntoQuery(String cookieString, Query cookies) {
        String[] parts2 = cookieString.split(";");
        if (parts2.length == 0) {
            return;
        }
        String[] nameAndValue = parts2[0].split("=");
        if (nameAndValue.length != 2) {
            return;
        }
        Struct cookieStruct = new Struct();
        cookieStruct.put(Key._NAME, (Object)nameAndValue[0]);
        cookieStruct.put(Key.value, (Object)nameAndValue[1]);
        if (parts2.length > 1) {
            Arrays.stream(parts2, 1, parts2.length).forEach(metadata -> {
                String[] metadataParts = metadata.split("=");
                if (metadataParts.length == 0) {
                    return;
                }
                Key metadataType = Key.of(metadataParts[0]);
                Object metadataValue = true;
                if (metadataParts.length == 2) {
                    metadataValue = metadataParts[1];
                }
                if (metadataType.equals(Key.of("max-age"))) {
                    metadataType = Key.expires;
                    metadataValue = StringCaster.cast(DoubleCaster.cast(metadataValue) / 60.0 / 60.0 / 24.0);
                }
                cookieStruct.put(metadataType, metadataValue);
            });
        }
        cookies.add(cookieStruct);
    }

    private String generateStatusLine(String httpVersionString, String statusCodeString, String statusText) {
        return httpVersionString + " " + statusCodeString + " " + statusText;
    }

    private String generateHeaderString(String statusLine, IStruct headers) {
        return statusLine + " " + headers.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> {
            StringBuilder sb = new StringBuilder();
            Object headerValues = entry.getValue();
            CastAttempt<Array> isValuesArray = ArrayCaster.attempt(headerValues);
            if (isValuesArray.wasSuccessful()) {
                Array values = (Array)isValuesArray.getOrFail();
                for (Object value : values) {
                    String headerValue = StringCaster.cast(value);
                    sb.append(((Key)entry.getKey()).getName() + ": " + headerValue + " ");
                }
            } else {
                String headerValue = StringCaster.cast(headerValues);
                sb.append(((Key)entry.getKey()).getName() + ": " + headerValue + " ");
            }
            return sb.toString().trim();
        }).collect(Collectors.joining(" "));
    }

    private IStruct transformToResponseHeaderStruct(Map<String, List<String>> headersMap) {
        Array values;
        Struct responseHeaders = new Struct();
        if (headersMap == null) {
            return responseHeaders;
        }
        for (String headerName : headersMap.keySet()) {
            if (":status".equals(headerName)) continue;
            Key headerNameKey = Key.of(headerName);
            values = (Array)responseHeaders.getOrDefault(headerNameKey, (Object)new Array());
            values.addAll((Collection<? extends Object>)headersMap.get(headerName));
            responseHeaders.put(headerNameKey, (Object)values);
        }
        for (Key structHeaderKey : responseHeaders.keySet()) {
            CastAttempt<Array> isValuesArray = ArrayCaster.attempt(responseHeaders.get(structHeaderKey));
            if (!isValuesArray.wasSuccessful() || (values = (Array)isValuesArray.getOrFail()).size() != 1) continue;
            responseHeaders.put(structHeaderKey, values.get(0));
        }
        return responseHeaders;
    }
}

