/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components.system;

import java.util.Map;
import java.util.Set;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.ExpressionInterpreter;
import ortus.boxlang.runtime.dynamic.IReferenceable;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.loader.ClassLocator;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.validation.Validator;

@BoxComponent(allowsBody=true)
public class Invoke
extends Component {
    ClassLocator classLocator = BoxRuntime.getInstance().getClassLocator();
    static final Set<Key> reservedAttributeNames = Set.of(Key._CLASS, Key.method, Key.returnVariable, Key.argumentCollection);

    public Invoke() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key._CLASS, "any", ""), new Attribute(Key.method, "string", Set.of(Validator.REQUIRED, Validator.NON_EMPTY)), new Attribute(Key.returnVariable, "string", Set.of(Validator.NON_EMPTY)), new Attribute(Key.argumentCollection, "any")};
    }

    @Override
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        String returnVariable = attributes.getAsString(Key.returnVariable);
        Key methodname = Key.of(attributes.getAsString(Key.method));
        Object instance = attributes.get(Key._CLASS);
        Object args = attributes.get(Key.argumentCollection);
        IStruct argCollection = Struct.of(new Object[0]);
        Object result = null;
        if (args != null) {
            argCollection.put(Key.argumentCollection, args);
        }
        attributes.forEach((key, value) -> {
            if (!reservedAttributeNames.contains(key)) {
                argCollection.put((Key)key, value);
            }
        });
        executionState.put(Key.invokeArgs, (Object)argCollection);
        executionState.put(Key.of("methodname"), (Object)methodname.getName());
        Component.BodyResult bodyResult = this.processBody(context, body);
        if (bodyResult.isEarlyExit()) {
            return bodyResult;
        }
        CastAttempt<String> stringCasterAttempt = StringCaster.attempt(instance);
        if (stringCasterAttempt.wasSuccessful() && stringCasterAttempt.get().isEmpty()) {
            result = context.invokeFunction(methodname, (Map<Key, Object>)argCollection);
        } else {
            IReferenceable actualInstance;
            if (stringCasterAttempt.wasSuccessful()) {
                actualInstance = (IClassRunnable)this.classLocator.load(context, "bx:" + stringCasterAttempt.get(), context.getCurrentImports()).invokeConstructor(context, Key.noInit).unWrapBoxLangClass();
            } else if (instance instanceof IReferenceable) {
                IReferenceable cvs;
                actualInstance = cvs = (IReferenceable)instance;
            } else {
                throw new BoxValidationException("The instance parameter must be a Box Class or the name of a Box Class to instantiate.");
            }
            result = actualInstance.dereferenceAndInvoke(context, methodname, argCollection, (Boolean)false);
        }
        if (returnVariable != null) {
            ExpressionInterpreter.setVariable(context, returnVariable, result);
        }
        return DEFAULT_RETURN;
    }
}

