/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components.system;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.LockException;
import ortus.boxlang.runtime.validation.Validator;

@BoxComponent(requiresBody=true)
public class Lock
extends Component {
    private ConcurrentHashMap<String, WeakReference<ReentrantReadWriteLock>> lockMap = new ConcurrentHashMap();
    private ReferenceQueue<ReentrantReadWriteLock> queue = new ReferenceQueue();

    public Lock() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key._NAME, "string", Set.of(Validator.NON_EMPTY)), new Attribute(Key.scope, "string"), new Attribute(Key.type, "string", "exclusive", Set.of(Validator.valueOneOf("readonly", "exclusive"))), new Attribute(Key.timeout, "Integer", Set.of(Validator.REQUIRED, Validator.min(0))), new Attribute(Key.throwOnTimeout, "boolean", true)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        Object lockName;
        String type = attributes.getAsString(Key.type).toLowerCase();
        String name = attributes.getAsString(Key._NAME);
        String scope = attributes.getAsString(Key.scope);
        Integer timeout = attributes.getAsInteger(Key.timeout);
        Boolean throwOnTimeout = attributes.getAsBoolean(Key.throwOnTimeout);
        if (name != null) {
            lockName = name.toLowerCase();
        } else {
            if (scope == null) throw new BoxRuntimeException("Lock requires either a 'name' or 'scope' attribute to be provided.");
            lockName = "scope_lock_" + context.getScopeNearby(Key.of(scope)).getLockName();
        }
        ReentrantReadWriteLock lock = this.getLockByName((String)lockName);
        ReentrantReadWriteLock.ReadLock readLock = lock.readLock();
        ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
        java.util.concurrent.locks.Lock lockToUse = null;
        try {
            boolean acquired;
            if (type.equals("readonly")) {
                if (timeout == 0) {
                    readLock.lock();
                    lockToUse = readLock;
                    acquired = true;
                } else {
                    acquired = readLock.tryLock(timeout.intValue(), TimeUnit.SECONDS);
                    lockToUse = readLock;
                }
            } else {
                if (!type.equals("exclusive")) throw new BoxRuntimeException("Lock type [" + type + "] is not supported");
                if (timeout == 0) {
                    writeLock.lock();
                    lockToUse = writeLock;
                    acquired = true;
                } else {
                    acquired = writeLock.tryLock(timeout.intValue(), TimeUnit.SECONDS);
                    lockToUse = writeLock;
                }
            }
            if (!acquired) {
                if (throwOnTimeout == false) return DEFAULT_RETURN;
                throw new LockException("Timeout of [" + timeout + "] seconds reached while waiting to acquire lock [" + (String)lockName + "]", (String)lockName, "timeout");
            }
            try {
                Component.BodyResult bodyResult = this.processBody(context, body);
                if (bodyResult.isEarlyExit()) {
                    Component.BodyResult bodyResult2 = bodyResult;
                    return bodyResult2;
                }
                Component.BodyResult bodyResult2 = DEFAULT_RETURN;
                return bodyResult2;
            }
            finally {
                lockToUse.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new LockException("Interrupted while waiting for lock", "", (String)lockName, "interrupted", e);
        }
    }

    private ReentrantReadWriteLock getLockByName(String lockName) {
        this.cleanUp();
        WeakReference lockRef;
        ReentrantReadWriteLock lock;
        while ((lock = (ReentrantReadWriteLock)(lockRef = this.lockMap.computeIfAbsent(lockName, key -> new WeakReference<ReentrantReadWriteLock>(new ReentrantReadWriteLock(), this.queue))).get()) == null) {
            this.lockMap.remove(lockName, lockRef);
        }
        return lock;
    }

    private void cleanUp() {
        Reference<ReentrantReadWriteLock> ref;
        while ((ref = this.queue.poll()) != null) {
            this.lockMap.values().remove(ref);
        }
    }
}

