/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components.system;

import java.util.Set;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.components.util.LoopUtil;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.ExpressionInterpreter;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.ListUtil;
import ortus.boxlang.runtime.util.FileSystemUtil;
import ortus.boxlang.runtime.validation.Validator;

@BoxComponent(requiresBody=true)
public class Loop
extends Component {
    public Loop() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key.array, "array"), new Attribute(Key.item, "string", Set.of(Validator.NON_EMPTY)), new Attribute(Key.index, "string", Set.of(Validator.NON_EMPTY)), new Attribute(Key.to, "double", Set.of(Validator.requires(Key.index))), new Attribute(Key.from, "double"), new Attribute(Key.file, "string", Set.of(Validator.requires(Key.index))), new Attribute(Key.list, "string"), new Attribute(Key.delimiters, "string"), new Attribute(Key.collection, "Struct", Set.of(Validator.requires(Key.item))), new Attribute(Key.condition, "function"), new Attribute(Key.query, "any"), new Attribute(Key.group, "string", Set.of(Validator.NON_EMPTY)), new Attribute(Key.groupCaseSensitive, "boolean", false), new Attribute(Key.startRow, "integer", Set.of(Validator.min(1))), new Attribute(Key.endRow, "integer", Set.of(Validator.min(1))), new Attribute(Key.label, "string", Set.of(Validator.NON_EMPTY)), new Attribute(Key.times, "integer", Set.of(Validator.min(0)))};
    }

    @Override
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        Array array = attributes.getAsArray(Key.array);
        String item = attributes.getAsString(Key.item);
        String index = attributes.getAsString(Key.index);
        Double to = attributes.getAsDouble(Key.to);
        Double from = attributes.getAsDouble(Key.from);
        String file = attributes.getAsString(Key.file);
        String list = attributes.getAsString(Key.list);
        String delimiters = attributes.getAsString(Key.delimiters);
        IStruct collection = attributes.getAsStruct(Key.collection);
        Function condition = attributes.getAsFunction(Key.condition);
        String group = attributes.getAsString(Key.group);
        Boolean groupCaseSensitive = attributes.getAsBoolean(Key.groupCaseSensitive);
        Integer startRow = attributes.getAsInteger(Key.startRow);
        Integer endRow = attributes.getAsInteger(Key.endRow);
        Object queryOrName = attributes.get(Key.query);
        String label = attributes.getAsString(Key.label);
        Integer times = attributes.getAsInteger(Key.times);
        if (times != null) {
            return this._invokeTimes(context, times, item, index, body, executionState, label);
        }
        if (array != null) {
            return this._invokeArray(context, array, item, index, body, executionState, label);
        }
        if (to != null && from != null) {
            return this._invokeRange(context, from, to, index, body, executionState, label);
        }
        if (file != null) {
            return this._invokeFile(context, file, index, body, executionState, label);
        }
        if (list != null) {
            if (delimiters == null) {
                delimiters = ",";
            }
            return this._invokeArray(context, ListUtil.asList(list, delimiters), item, index, body, executionState, label);
        }
        if (collection != null) {
            return this._invokeCollection(context, collection, item, body, executionState, label);
        }
        if (condition != null) {
            return this._invokeCondition(context, condition, body, executionState, label);
        }
        if (queryOrName != null) {
            return LoopUtil.processQueryLoop(this, context, body, executionState, queryOrName, group, groupCaseSensitive, startRow, endRow, null, label);
        }
        throw new BoxRuntimeException("CFLoop attributes not implemented yet! " + attributes.asString());
    }

    private Component.BodyResult _invokeTimes(IBoxContext context, Integer times, String item, String index, Component.ComponentBody body, IStruct executionState, String label) {
        if (index == null && item != null) {
            index = item;
            item = null;
        }
        for (int i = 1; i <= times; ++i) {
            Component.BodyResult bodyResult;
            if (index != null) {
                ExpressionInterpreter.setVariable(context, index, i);
            }
            if (!(bodyResult = this.processBody(context, body)).isEarlyExit() || bodyResult.isContinue(label)) continue;
            if (bodyResult.isBreak(label)) break;
            return bodyResult;
        }
        return DEFAULT_RETURN;
    }

    private Component.BodyResult _invokeCondition(IBoxContext context, Function condition, Component.ComponentBody body, IStruct executionState, String label) {
        while (BooleanCaster.cast(context.invokeFunction(condition)).booleanValue()) {
            Component.BodyResult bodyResult = this.processBody(context, body);
            if (!bodyResult.isEarlyExit() || bodyResult.isContinue(label)) continue;
            if (bodyResult.isBreak(label)) break;
            return bodyResult;
        }
        return DEFAULT_RETURN;
    }

    private Component.BodyResult _invokeCollection(IBoxContext context, IStruct collection, String item, Component.ComponentBody body, IStruct executionState, String label) {
        for (Key key : collection.keySet()) {
            ExpressionInterpreter.setVariable(context, item, key.getName());
            Component.BodyResult bodyResult = this.processBody(context, body);
            if (!bodyResult.isEarlyExit() || bodyResult.isContinue(label)) continue;
            if (bodyResult.isBreak(label)) break;
            return bodyResult;
        }
        return DEFAULT_RETURN;
    }

    private Component.BodyResult _invokeFile(IBoxContext context, String file, String index, Component.ComponentBody body, IStruct executionState, String label) {
        String fileContents = StringCaster.cast(FileSystemUtil.read(file));
        String[] lines = fileContents.split("\r?\n");
        for (int i = 0; i < lines.length; ++i) {
            String thisLine = lines[i];
            ExpressionInterpreter.setVariable(context, index, thisLine);
            Component.BodyResult bodyResult = this.processBody(context, body);
            if (!bodyResult.isEarlyExit() || bodyResult.isContinue(label)) continue;
            if (bodyResult.isBreak(label)) break;
            return bodyResult;
        }
        return DEFAULT_RETURN;
    }

    private Component.BodyResult _invokeRange(IBoxContext context, Double from, Double to, String index, Component.ComponentBody body, IStruct executionState, String label) {
        for (int i = from.intValue(); i <= to.intValue(); ++i) {
            ExpressionInterpreter.setVariable(context, index, i);
            Component.BodyResult bodyResult = this.processBody(context, body);
            if (!bodyResult.isEarlyExit() || bodyResult.isContinue(label)) continue;
            if (bodyResult.isBreak(label)) break;
            return bodyResult;
        }
        return DEFAULT_RETURN;
    }

    private Component.BodyResult _invokeArray(IBoxContext context, Array array, String item, String index, Component.ComponentBody body, IStruct executionState, String label) {
        if (item == null && index != null) {
            item = index;
            index = null;
        }
        for (int i = 0; i < array.size(); ++i) {
            Component.BodyResult bodyResult;
            if (index != null) {
                ExpressionInterpreter.setVariable(context, index, i + 1);
            }
            if (item != null) {
                ExpressionInterpreter.setVariable(context, item, array.get(i));
            }
            if (!(bodyResult = this.processBody(context, body)).isEarlyExit() || bodyResult.isContinue(label)) continue;
            if (bodyResult.isBreak(label)) break;
            return bodyResult;
        }
        return DEFAULT_RETURN;
    }
}

