/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components.system;

import java.util.Set;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.components.util.LoopUtil;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.validation.Validator;

@BoxComponent(requiresBody=true)
public class Output
extends Component {
    public Output() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key.query, "any"), new Attribute(Key.group, "string", Set.of(Validator.NON_EMPTY)), new Attribute(Key.groupCaseSensitive, "boolean", false), new Attribute(Key.startRow, "integer", Set.of(Validator.min(1))), new Attribute(Key.maxRows, "integer", Set.of(Validator.min(0))), new Attribute(Key.encodefor, "string")};
    }

    @Override
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        IStruct parent;
        String encodeFor = attributes.getAsString(Key.encodefor);
        if (encodeFor == null && (parent = context.findClosestComponent(Key.output, state -> state.get(Key.encodefor) != null)) != null) {
            encodeFor = parent.getAsString(Key.encodefor);
        }
        executionState.put(Key.encodefor, (Object)encodeFor);
        Object queryOrName = attributes.get(Key.query);
        if (queryOrName == null) {
            Component.BodyResult bodyResult = this.processBody(context, body);
            if (bodyResult.isEarlyExit()) {
                return bodyResult;
            }
            return DEFAULT_RETURN;
        }
        String group = attributes.getAsString(Key.group);
        Boolean groupCaseSensitive = attributes.getAsBoolean(Key.groupCaseSensitive);
        Integer startRow = attributes.getAsInteger(Key.startRow);
        Integer maxRows = attributes.getAsInteger(Key.maxRows);
        return LoopUtil.processQueryLoop(this, context, body, executionState, queryOrName, group, groupCaseSensitive, startRow, null, maxRows, null);
    }
}

