/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components.system;

import java.util.Set;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.ExpressionInterpreter;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.validation.Validator;

@BoxComponent(requiresBody=true)
public class SaveContent
extends Component {
    public SaveContent() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key.variable, "string", Set.of(Validator.REQUIRED, Validator.NON_EMPTY)), new Attribute(Key.trim, "boolean", false), new Attribute(Key.append, "boolean", false)};
    }

    @Override
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        Object priorContent;
        StringBuffer buffer = new StringBuffer();
        Component.BodyResult bodyResult = this.processBody(context, body, buffer);
        if (bodyResult.isEarlyExit()) {
            return bodyResult;
        }
        String content = buffer.toString();
        String variableName = attributes.getAsString(Key.variable);
        boolean trim = attributes.getAsBoolean(Key.trim);
        boolean append = attributes.getAsBoolean(Key.append);
        if (trim) {
            content = content.trim();
        }
        if (append && (priorContent = ExpressionInterpreter.getVariable(context, variableName, true)) != null) {
            content = StringCaster.cast(priorContent).concat(content);
        }
        ExpressionInterpreter.setVariable(context, variableName, content);
        return DEFAULT_RETURN;
    }
}

