/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components.util;

import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.ExpressionInterpreter;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.GenericCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.operators.EqualsEquals;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.util.ListUtil;

public class LoopUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component.BodyResult processQueryLoop(Component component, IBoxContext context, Component.ComponentBody body, IStruct executionState, Object queryOrName, String group, Boolean groupCaseSensitive, Integer startRow, Integer endRow, Integer maxRows, String label) {
        int iStartRow;
        CastAttempt<String> queryName = StringCaster.attempt(queryOrName);
        if (queryName.wasSuccessful()) {
            if (queryName.get().isEmpty()) {
                throw new IllegalArgumentException("The query name cannot be empty");
            }
            queryOrName = ExpressionInterpreter.getVariable(context, queryName.get(), false);
        }
        Query theQuery = (Query)GenericCaster.cast(context, queryOrName, "query");
        int n = iStartRow = startRow == null ? 0 : startRow - 1;
        int iEndRow = endRow != null ? endRow - 1 : (maxRows == null ? theQuery.size() - 1 : maxRows + iStartRow - 1);
        if ((iEndRow = Math.min(iEndRow, theQuery.size() - 1)) < iStartRow) {
            return Component.DEFAULT_RETURN;
        }
        boolean isGrouped = group != null;
        Key[] groupKeys = null;
        Object[] lastGroupValues = null;
        HashMap<String, Boolean> isSameGroup = new HashMap<String, Boolean>();
        int currentGroupEndRow = 0;
        isSameGroup.put("value", true);
        if (isGrouped) {
            groupKeys = (Key[])ListUtil.asList(group, ",").stream().map(c -> Key.of(((String)c).trim())).toArray(Key[]::new);
            lastGroupValues = new Object[groupKeys.length];
            lastGroupValues = LoopUtil.getGroupValuesForRow(theQuery, groupKeys, lastGroupValues, iStartRow, isSameGroup);
        }
        context.registerQueryLoop(theQuery, iStartRow);
        try {
            for (int i = iStartRow; i <= iEndRow; ++i) {
                Component.BodyResult bodyResult;
                if (isGrouped) {
                    if (i < iEndRow) {
                        lastGroupValues = LoopUtil.getGroupValuesForRow(theQuery, groupKeys, lastGroupValues, i + 1, isSameGroup);
                    } else {
                        isSameGroup.put("value", false);
                    }
                    if (((Boolean)isSameGroup.get("value")).booleanValue()) continue;
                    currentGroupEndRow = i;
                }
                if ((bodyResult = component.processBody(context, body)).isEarlyExit()) {
                    if (bodyResult.isContinue(label)) {
                        context.registerQueryLoop(theQuery, i + 1);
                        continue;
                    }
                    if (bodyResult.isBreak(label)) {
                        break;
                    }
                    Component.BodyResult bodyResult2 = bodyResult;
                    return bodyResult2;
                }
                context.registerQueryLoop(theQuery, i + 1);
            }
        }
        finally {
            context.unregisterQueryLoop(theQuery);
        }
        return Component.DEFAULT_RETURN;
    }

    private static Object[] getGroupValuesForRow(Query query, Key[] groupKeys, Object[] lastGroupValues, int row, Map<String, Boolean> isSameGroup) {
        Object[] thisGroupValues = new Object[groupKeys.length];
        isSameGroup.put("value", true);
        for (int j = 0; j < groupKeys.length; ++j) {
            thisGroupValues[j] = query.getCell(groupKeys[j], row);
            if (EqualsEquals.invoke(thisGroupValues[j], lastGroupValues[j]).booleanValue()) continue;
            isSameGroup.put("value", false);
        }
        return thisGroupValues;
    }
}

