/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.components.zip;

import java.util.Set;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.ExpressionInterpreter;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.ZipUtil;
import ortus.boxlang.runtime.validation.Validator;

@BoxComponent(allowsBody=true, alias="gzip")
public class Zip
extends Component {
    public Zip() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key.action, "string", "zip", Set.of(Validator.NON_EMPTY, Validator.valueOneOf("delete", "list", "read", "readBinary", "unzip", "zip"))), new Attribute(Key.file, "string", Set.of(Validator.NON_EMPTY)), new Attribute(Key.destination, "string", Set.of(Validator.NON_EMPTY)), new Attribute(Key.filter, "any", Set.of(Validator.NON_EMPTY)), new Attribute(Key.entryPath, "any", Set.of(Validator.NON_EMPTY)), new Attribute(Key.charset, "string", Set.of(Validator.NON_EMPTY)), new Attribute(Key.result, "string", "bxzip", Set.of(Validator.NON_EMPTY)), new Attribute(Key.overwrite, "boolean", false), new Attribute(Key.prefix, "string", Set.of(Validator.NON_EMPTY)), new Attribute(Key.recurse, "boolean", true), new Attribute(Key.flatList, "boolean", false), new Attribute(Key.source, "string", Set.of(Validator.NON_EMPTY)), new Attribute(Key.variable, "string", Set.of(Validator.NON_EMPTY))};
    }

    @Override
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        String action;
        executionState.put(Key.zipParams, (Object)new Array());
        Component.BodyResult bodyResult = this.processBody(context, body);
        if (bodyResult.isEarlyExit()) {
            return bodyResult;
        }
        switch (action = StringCaster.cast(attributes.getOrDefault(Key.action, (Object)"zip"))) {
            case "delete": {
                this.delete(context, attributes, executionState);
                break;
            }
            case "list": {
                this.list(context, attributes, executionState);
                break;
            }
            case "read": {
                this.read(context, attributes, executionState);
                break;
            }
            case "readBinary": {
                this.readBinary(context, attributes, executionState);
                break;
            }
            case "unzip": {
                this.unzip(context, attributes, executionState);
                break;
            }
            case "zip": {
                this.zip(context, attributes, executionState);
                break;
            }
            default: {
                throw new BoxRuntimeException(action + " is not a valid action for the Zip component. Valid actions are: delete, list, read, readBinary, unzip, zip");
            }
        }
        return DEFAULT_RETURN;
    }

    private void delete(IBoxContext context, IStruct attributes, IStruct executionState) {
        String filepath = StringCaster.cast(attributes.get(Key.file));
        if (filepath == null || filepath.isEmpty()) {
            throw new BoxRuntimeException("The file attribute is required for the delete action");
        }
        Object filter = attributes.get(Key.filter);
        Array entryPaths = this.toArrayOfEntryPaths(attributes.get(Key.entryPath));
        ZipUtil.deleteEntries(filepath, filter, entryPaths, context);
    }

    private void list(IBoxContext context, IStruct attributes, IStruct executionState) {
        String source = StringCaster.cast(attributes.get(Key.file));
        if (source == null || source.isEmpty()) {
            throw new BoxRuntimeException("The file attribute is required for the list action");
        }
        Object filter = attributes.get(Key.filter);
        String variableName = StringCaster.cast(attributes.getOrDefault(Key._NAME, (Object)"bxzip"));
        boolean recurse = Boolean.TRUE.equals(attributes.get(Key.recurse));
        boolean flatList = Boolean.TRUE.equals(attributes.get(Key.flatList));
        Array results = flatList ? ZipUtil.listEntriesFlat(source, filter, recurse, context) : ZipUtil.listEntries(source, filter, recurse, context);
        ExpressionInterpreter.setVariable(context, variableName, results);
    }

    private void read(IBoxContext context, IStruct attributes, IStruct executionState) {
        String source = StringCaster.cast(attributes.get(Key.file));
        String entryPath = StringCaster.cast(attributes.get(Key.entryPath));
        if (source == null || source.isEmpty()) {
            throw new BoxRuntimeException("The file attribute is required for the read action");
        }
        if (entryPath == null || entryPath.isEmpty()) {
            throw new BoxRuntimeException("The entryPath attribute is required for the read action");
        }
        Object charset = attributes.get(Key.charset);
        String variable = StringCaster.cast(attributes.getOrDefault(Key.variable, (Object)"bxzip"));
        String content = charset == null ? ZipUtil.readEntry(source, entryPath) : ZipUtil.readEntry(source, entryPath, StringCaster.cast(charset));
        ExpressionInterpreter.setVariable(context, variable, content);
    }

    private void readBinary(IBoxContext context, IStruct attributes, IStruct executionState) {
        String source = StringCaster.cast(attributes.get(Key.file));
        String entryPath = StringCaster.cast(attributes.get(Key.entryPath));
        if (source == null || source.isEmpty()) {
            throw new BoxRuntimeException("The file attribute is required for the readAsBinary action");
        }
        if (entryPath == null || entryPath.isEmpty()) {
            throw new BoxRuntimeException("The entryPath attribute is required for the readAsBinary action");
        }
        String variable = StringCaster.cast(attributes.getOrDefault(Key.variable, (Object)"bxzip"));
        byte[] content = ZipUtil.readBinaryEntry(source, entryPath);
        ExpressionInterpreter.setVariable(context, variable, content);
    }

    private void unzip(IBoxContext context, IStruct attributes, IStruct executionState) {
        String source = StringCaster.cast(attributes.get(Key.file));
        String destination = StringCaster.cast(attributes.get(Key.destination));
        if (source == null || source.isEmpty()) {
            throw new BoxRuntimeException("The file attribute is required for the unzip action");
        }
        if (destination == null || destination.isEmpty()) {
            throw new BoxRuntimeException("The destination attribute is required for the unzip action");
        }
        Object filter = attributes.get(Key.filter);
        Array entryPaths = this.toArrayOfEntryPaths(attributes.get(Key.entryPath));
        boolean overwrite = Boolean.TRUE.equals(attributes.get(Key.overwrite));
        boolean recurse = Boolean.TRUE.equals(attributes.get(Key.recurse));
        ZipUtil.extractZip(source, destination, overwrite, recurse, filter, entryPaths, context);
    }

    private void zip(IBoxContext context, IStruct attributes, IStruct executionState) {
        String destinationFile = StringCaster.cast(attributes.get(Key.file));
        String source = StringCaster.cast(attributes.get(Key.source));
        if (destinationFile == null || destinationFile.isEmpty()) {
            throw new BoxRuntimeException("The file attribute is required for the zip action");
        }
        if (source == null || source.isEmpty()) {
            throw new BoxRuntimeException("The source attribute is required for the zip action");
        }
        Object filter = attributes.get(Key.filter);
        boolean overwrite = Boolean.TRUE.equals(attributes.get(Key.overwrite));
        boolean recurse = Boolean.TRUE.equals(attributes.get(Key.recurse));
        Object prefix = attributes.get(Key.prefix);
        ZipUtil.compressZip(source, destinationFile, true, overwrite, prefix != null ? StringCaster.cast(prefix) : null, filter, recurse, context);
    }

    private Array toArrayOfEntryPaths(Object entryPath) {
        Array paths = new Array();
        if (entryPath instanceof String) {
            paths.add(entryPath);
        } else if (entryPath instanceof Array) {
            return (Array)entryPath;
        }
        return paths;
    }
}

