/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.config;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.config.Configuration;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.ConfigurationException;
import ortus.boxlang.runtime.types.unmodifiable.UnmodifiableStruct;
import ortus.boxlang.runtime.types.util.BLCollector;
import ortus.boxlang.runtime.types.util.JSONUtil;
import ortus.boxlang.runtime.types.util.ListUtil;
import ortus.boxlang.runtime.types.util.StructUtil;

public class ConfigLoader {
    private static final String DEFAULT_CONFIG_FILE = "config/boxlang.json";
    private static ConfigLoader instance;
    private static final Logger logger;
    private static final String ENV_PREFIX = "BOXLANG_";
    private static final String PROPERTY_PREFIX = "boxlang.";

    private ConfigLoader() {
    }

    public static synchronized ConfigLoader getInstance() {
        if (instance == null) {
            instance = new ConfigLoader();
        }
        return instance;
    }

    public Configuration loadCore() {
        return this.loadFromResources(DEFAULT_CONFIG_FILE);
    }

    public Configuration loadFromResources(String configFile) {
        Object rawConfig = JSONUtil.fromJSON(ConfigLoader.class.getClassLoader().getResourceAsStream(configFile), true);
        if (rawConfig instanceof Map) {
            logger.debug("Loaded internal BoxLang configuration file [{}]", (Object)configFile);
            return this.loadFromMap((Map)rawConfig);
        }
        throw new ConfigurationException("The config map is not a JSON object. Can't work with it.");
    }

    public Configuration loadFromMap(IStruct configMap) {
        return new Configuration().process(this.mergeEnvironmentOverrides(configMap));
    }

    public Configuration loadFromMap(Map<Object, Object> configMap) {
        return this.loadFromMap(new Struct(configMap));
    }

    public Configuration loadFromFile(File source) {
        IStruct rawConfig = this.deserializeConfig(source);
        logger.debug("Loaded custom BoxLang configuration file [{}]", (Object)source);
        return this.loadFromMap(rawConfig);
    }

    public Configuration loadFromFile(Path source) {
        return this.loadFromFile(source.toFile());
    }

    public Configuration loadFromFile(URL source) {
        return this.loadFromFile(new File(source.getFile()));
    }

    public Configuration loadFromFile(String source) {
        return this.loadFromFile(new File(source));
    }

    public IStruct deserializeConfig(File source) {
        Object rawConfig = JSONUtil.fromJSON(source, true);
        if (rawConfig instanceof Map) {
            return new Struct((Map)rawConfig);
        }
        throw new ConfigurationException("The config map is not a JSON object. Can't work with it.");
    }

    public IStruct deserializeConfig(String source) {
        return this.deserializeConfig(new File(source));
    }

    public IStruct deserializeConfig(URL source) {
        return this.deserializeConfig(new File(source.getFile()));
    }

    public IStruct deserializeConfig(Path source) {
        return this.deserializeConfig(source.toFile());
    }

    public IStruct mergeEnvironmentOverrides(IStruct config) {
        UnmodifiableStruct collectedEnvironment = UnmodifiableStruct.of(new Object[]{Key.environment, UnmodifiableStruct.fromMap(System.getenv()), Key.properties, UnmodifiableStruct.fromMap(System.getProperties())});
        IStruct propertyOverrides = this.filterEnv(collectedEnvironment.getAsStruct(Key.properties));
        IStruct envOverrides = this.filterEnv(collectedEnvironment.getAsStruct(Key.environment)).entrySet().stream().filter(entry -> !propertyOverrides.containsKey((Key)entry.getKey())).collect(BLCollector.toStruct());
        if (envOverrides.isEmpty() && propertyOverrides.isEmpty()) {
            return config;
        }
        IStruct flatConfig = StructUtil.toFlatMap(config);
        if (!propertyOverrides.isEmpty()) {
            propertyOverrides.entrySet().stream().forEach(entry -> ConfigLoader.applyOverride(entry, flatConfig));
        }
        if (!envOverrides.isEmpty()) {
            envOverrides.entrySet().stream().forEach(entry -> ConfigLoader.applyOverride(entry, flatConfig));
        }
        return StructUtil.unFlattenKeys(flatConfig, true, false);
    }

    public IStruct filterEnv(IStruct envCollection) {
        return envCollection.entrySet().stream().filter(entry -> ((Key)entry.getKey()).getName().toUpperCase().startsWith(ENV_PREFIX) || ((Key)entry.getKey()).getName().toLowerCase().startsWith(PROPERTY_PREFIX)).map(entry -> {
            Array keyList = ListUtil.asList(((Key)entry.getKey()).getName().toLowerCase().replace("_", "."), ".");
            keyList.remove(0);
            String key = ListUtil.asString(keyList, ".");
            return Map.entry(Key.of(key), entry.getValue());
        }).collect(BLCollector.toStruct());
    }

    public static void applyOverride(Map.Entry<Key, Object> entry, IStruct flatConfig) {
        logger.debug("Overriding runtime config [{}] with Java System property value [{}]", (Object)entry.getKey().getName(), entry.getValue());
        Object existing = flatConfig.get(entry.getKey());
        if (existing != null) {
            if (existing instanceof List) {
                flatConfig.put(entry.getKey(), (Object)ListUtil.asList(StringCaster.cast(entry.getValue()), ","));
            } else if (existing instanceof Map) {
                try {
                    IStruct configValue = StructCaster.cast(JSONUtil.fromJSON(StringCaster.cast(entry.getValue()), true));
                    flatConfig.put(entry.getKey(), (Object)configValue);
                }
                catch (Exception e) {
                    logger.error("Failed to merge property override [{}]. The value of [{}] could not be converted to a struct", (Object)entry.getKey().getName(), entry.getValue());
                }
            } else {
                flatConfig.put(entry.getKey(), entry.getValue());
            }
        } else {
            flatConfig.put(entry.getKey(), entry.getValue());
        }
    }

    static {
        logger = LoggerFactory.getLogger(ConfigLoader.class);
    }
}

