/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.config;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.config.segments.CacheConfig;
import ortus.boxlang.runtime.config.segments.DatasourceConfig;
import ortus.boxlang.runtime.config.segments.ExecutorConfig;
import ortus.boxlang.runtime.config.segments.IConfigSegment;
import ortus.boxlang.runtime.config.segments.ModuleConfig;
import ortus.boxlang.runtime.config.segments.SecurityConfig;
import ortus.boxlang.runtime.config.util.PlaceholderHelper;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.KeyCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.loader.DynamicClassLoader;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.DateTimeHelper;
import ortus.boxlang.runtime.util.DataNavigator;
import ortus.boxlang.runtime.util.LocalizationUtil;

public class Configuration
implements IConfigSegment {
    public String classGenerationDirectory = System.getProperty("java.io.tmpdir") + "boxlang";
    public Boolean debugMode = false;
    public ZoneId timezone = TimeZone.getDefault().toZoneId();
    public Locale locale = Locale.getDefault();
    public Boolean invokeImplicitAccessor = true;
    public Boolean useHighPrecisionMath = true;
    public Duration applicationTimeout = Duration.ofDays(0L);
    public Duration requestTimeout = Duration.ofSeconds(0L);
    public Duration sessionTimeout = Duration.ofMinutes(30L);
    public Boolean sessionManagement = false;
    public String sessionStorage = "memory";
    public Boolean setClientCookies = true;
    public Boolean setDomainCookies = true;
    public IStruct mappings = new Struct(Struct.KEY_LENGTH_LONGEST_FIRST_COMPARATOR);
    public List<String> modulesDirectory = new ArrayList<String>(Arrays.asList(BoxRuntime.getInstance().getRuntimeHome().toString() + "/modules"));
    public String logsDirectory = Paths.get(BoxRuntime.getInstance().getRuntimeHome().toString(), "/logs").normalize().toString();
    public List<String> customTagsDirectory = new ArrayList<String>(Arrays.asList(BoxRuntime.getInstance().getRuntimeHome().toString() + "/customTags"));
    public List<String> javaLibraryPaths = new ArrayList<String>(Arrays.asList(BoxRuntime.getInstance().getRuntimeHome().toString() + "/lib"));
    public IStruct caches = new Struct();
    public String defaultDatasource = "";
    public IStruct datasources = new Struct();
    public String defaultRemoteMethodReturnFormat = "json";
    public CacheConfig defaultCache = new CacheConfig();
    public IStruct modules = new Struct();
    public IStruct originalConfig = new Struct();
    public IStruct executors = new Struct();
    public Set<String> validClassExtensions = new HashSet<String>();
    public Set<String> validTemplateExtensions = new HashSet<String>();
    public IStruct experimental = new Struct();
    public SecurityConfig security = new SecurityConfig();
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);

    @Override
    public Configuration process(IStruct config) {
        List castedList;
        IStruct castedMap;
        Object v;
        this.originalConfig = config;
        if (config.containsKey("debugMode")) {
            this.debugMode = BooleanCaster.cast(PlaceholderHelper.resolve(config.get("debugMode")));
        }
        if (config.containsKey("debuggingEnabled")) {
            this.debugMode = BooleanCaster.cast(PlaceholderHelper.resolve(config.get("debuggingEnabled")));
        }
        if (config.containsKey("classGenerationDirectory")) {
            this.classGenerationDirectory = PlaceholderHelper.resolve(config.get("classGenerationDirectory"));
        }
        if (config.containsKey(Key.timezone) && config.getAsString(Key.timezone).length() > 0) {
            this.timezone = ZoneId.of(PlaceholderHelper.resolve(config.get(Key.timezone)));
        }
        if (config.containsKey(Key.locale) && config.getAsString(Key.locale).length() > 0) {
            this.locale = LocalizationUtil.parseLocale(PlaceholderHelper.resolve(config.getAsString(Key.locale)));
        }
        if (config.containsKey(Key.invokeImplicitAccessor)) {
            BooleanCaster.attempt(PlaceholderHelper.resolve(config.get(Key.invokeImplicitAccessor))).ifSuccessful(value -> {
                this.invokeImplicitAccessor = value;
            });
        }
        if (config.containsKey(Key.useHighPrecisionMath)) {
            BooleanCaster.attempt(PlaceholderHelper.resolve(config.get(Key.useHighPrecisionMath))).ifSuccessful(value -> {
                this.useHighPrecisionMath = value;
            });
        }
        if (config.containsKey(Key.applicationTimeout) && StringCaster.cast(config.get("applicationTimeout")).length() > 0) {
            this.applicationTimeout = DateTimeHelper.timespanToDuration(PlaceholderHelper.resolve(config.get("applicationTimeout")));
        }
        if (config.containsKey(Key.requestTimeout) && StringCaster.cast(config.get("requestTimeout")).length() > 0) {
            this.requestTimeout = DateTimeHelper.timespanToDuration(PlaceholderHelper.resolve(config.get("requestTimeout")));
        }
        if (config.containsKey(Key.sessionTimeout) && StringCaster.cast(config.get("sessionTimeout")).length() > 0) {
            this.sessionTimeout = DateTimeHelper.timespanToDuration(PlaceholderHelper.resolve(config.get("sessionTimeout")));
        }
        if (config.containsKey(Key.sessionManagement)) {
            BooleanCaster.attempt(PlaceholderHelper.resolve(config.get(Key.sessionManagement))).ifSuccessful(value -> {
                this.sessionManagement = value;
            });
        }
        if (config.containsKey(Key.sessionStorage) && StringCaster.cast(config.get("sessionStorage")).length() > 0) {
            this.sessionStorage = PlaceholderHelper.resolve(config.get("sessionStorage"));
        }
        if (config.containsKey(Key.setClientCookies)) {
            BooleanCaster.attempt(PlaceholderHelper.resolve(config.get(Key.setClientCookies))).ifSuccessful(value -> {
                this.setClientCookies = value;
            });
        }
        if (config.containsKey(Key.setDomainCookies)) {
            BooleanCaster.attempt(PlaceholderHelper.resolve(config.get(Key.setDomainCookies))).ifSuccessful(value -> {
                this.setDomainCookies = value;
            });
        }
        if (config.containsKey(Key.mappings)) {
            v = config.get(Key.mappings);
            if (v instanceof IStruct) {
                castedMap = (IStruct)v;
                castedMap.entrySet().forEach(entry -> this.mappings.put((Key)entry.getKey(), (Object)PlaceholderHelper.resolve(entry.getValue())));
            } else {
                logger.warn("The [runtime.mappings] configuration is not a JSON Object, ignoring it.");
            }
        }
        if (config.containsKey(Key.modulesDirectory)) {
            v = config.get(Key.modulesDirectory);
            if (v instanceof List) {
                castedList = (List)v;
                castedList.forEach(item -> {
                    String resolvedItem = PlaceholderHelper.resolve(item);
                    if (!this.modulesDirectory.contains(resolvedItem)) {
                        this.modulesDirectory.add(resolvedItem);
                    }
                });
            } else {
                logger.warn("The [runtime.modulesDirectory] configuration is not a JSON Array, ignoring it.");
            }
        }
        if (config.containsKey(Key.customTagsDirectory)) {
            v = config.get(Key.customTagsDirectory);
            if (v instanceof List) {
                castedList = (List)v;
                castedList.forEach(item -> {
                    String resolvedItem = PlaceholderHelper.resolve(item);
                    if (!this.customTagsDirectory.contains(resolvedItem)) {
                        this.customTagsDirectory.add(resolvedItem);
                    }
                });
            } else {
                logger.warn("The [runtime.customTagsDirectory] configuration is not a JSON Array, ignoring it.");
            }
        }
        if (config.containsKey(Key.javaLibraryPaths)) {
            v = config.get(Key.javaLibraryPaths);
            if (v instanceof List) {
                castedList = (List)v;
                castedList.forEach(item -> {
                    String resolvedItem = PlaceholderHelper.resolve(item);
                    if (!this.javaLibraryPaths.contains(resolvedItem)) {
                        this.javaLibraryPaths.add(resolvedItem);
                    }
                });
            } else {
                logger.warn("The [javaLibraryPaths] configuration is not a JSON Array, ignoring it.");
            }
        }
        if (config.containsKey(Key.defaultRemoteMethodReturnFormat)) {
            this.defaultRemoteMethodReturnFormat = PlaceholderHelper.resolve(config.get(Key.defaultRemoteMethodReturnFormat)).toLowerCase();
        }
        if (config.containsKey(Key.defaultCache)) {
            v = config.get(Key.defaultCache);
            if (v instanceof IStruct) {
                castedMap = (IStruct)v;
                this.defaultCache = new CacheConfig().processProperties(castedMap);
            } else {
                logger.warn("The [runtime.defaultCache] configuration is not a JSON Object, ignoring it.");
            }
        }
        if (config.containsKey(Key.caches)) {
            v = config.get(Key.caches);
            if (v instanceof IStruct) {
                IStruct castedCaches = (IStruct)v;
                castedCaches.entrySet().forEach(entry -> {
                    if (((Key)entry.getKey()).equals(Key._DEFAULT)) {
                        return;
                    }
                    Object patt0$temp = entry.getValue();
                    if (patt0$temp instanceof IStruct) {
                        IStruct castedStruct = (IStruct)patt0$temp;
                        CacheConfig cacheConfig = new CacheConfig(KeyCaster.cast(entry.getKey())).process(castedStruct);
                        this.caches.put(cacheConfig.name, (Object)cacheConfig);
                    } else {
                        logger.warn("The [caches.{}] configuration is not a JSON Object, ignoring it.", (Object)((Key)entry.getKey()).getName());
                    }
                });
            } else {
                logger.warn("The [caches] configuration is not a JSON Object, ignoring it.");
            }
        }
        if (config.containsKey(Key.executors)) {
            v = config.get(Key.executors);
            if (v instanceof IStruct) {
                IStruct castedExecutors = (IStruct)v;
                castedExecutors.entrySet().forEach(entry -> {
                    Object patt0$temp = entry.getValue();
                    if (patt0$temp instanceof IStruct) {
                        IStruct castedMap = (IStruct)patt0$temp;
                        ExecutorConfig executorConfig = new ExecutorConfig((Key)entry.getKey()).process(StructCaster.cast(castedMap));
                        this.executors.put(executorConfig.name, (Object)executorConfig);
                    } else {
                        logger.warn("The [executors.{}] configuration is not a JSON Object, ignoring it.", entry.getKey());
                    }
                });
            } else {
                logger.warn("The [executors] configuration is not a JSON Object, ignoring it.");
            }
        }
        if (config.containsKey(Key.validClassExtensions)) {
            v = config.get(Key.validClassExtensions);
            if (v instanceof List) {
                castedList = (List)v;
                castedList.forEach(item -> this.validClassExtensions.add(PlaceholderHelper.resolve(item).toLowerCase()));
            } else {
                logger.warn("The [validClassExtensions] configuration is not a JSON Array, ignoring it.");
            }
        }
        if (config.containsKey(Key.validTemplateExtensions)) {
            v = config.get(Key.validTemplateExtensions);
            if (v instanceof List) {
                castedList = (List)v;
                castedList.forEach(item -> this.validTemplateExtensions.add(PlaceholderHelper.resolve(item).toLowerCase()));
            } else {
                logger.warn("The [validTemplateExtensions] configuration is not a JSON Array, ignoring it.");
            }
        }
        if (config.containsKey(Key.experimental)) {
            v = config.get(Key.experimental);
            if (v instanceof IStruct) {
                IStruct castedStruct = (IStruct)v;
                castedStruct.entrySet().forEach(entry -> this.experimental.put((Key)entry.getKey(), (Object)PlaceholderHelper.resolve(entry.getValue())));
            } else {
                logger.warn("The [runtime.experimental] configuration is not a JSON Object, ignoring it.");
            }
        }
        if (config.containsKey(Key.defaultDatasource)) {
            this.defaultDatasource = PlaceholderHelper.resolve(config.get(Key.defaultDatasource));
        }
        if (config.containsKey(Key.datasources)) {
            v = config.get(Key.datasources);
            if (v instanceof IStruct) {
                IStruct castedDataSources = (IStruct)v;
                castedDataSources.entrySet().forEach(entry -> {
                    Object patt0$temp = entry.getValue();
                    if (patt0$temp instanceof IStruct) {
                        IStruct castedStruct = (IStruct)patt0$temp;
                        DatasourceConfig datasourceConfig = new DatasourceConfig((Key)entry.getKey()).process(new Struct(castedStruct));
                        this.datasources.put(datasourceConfig.name, (Object)datasourceConfig);
                    } else {
                        logger.warn("The [runtime.datasources.{}] configuration is not a JSON Object, ignoring it.", entry.getKey());
                    }
                });
            } else {
                logger.warn("The [runtime.datasources] configuration is not a JSON Object, ignoring it.");
            }
        }
        if (config.containsKey(Key.modules)) {
            v = config.get(Key.modules);
            if (v instanceof IStruct) {
                IStruct castedModules = (IStruct)v;
                castedModules.entrySet().forEach(entry -> {
                    Object patt0$temp = entry.getValue();
                    if (patt0$temp instanceof IStruct) {
                        IStruct castedMap = (IStruct)patt0$temp;
                        ModuleConfig moduleConfig = new ModuleConfig(((Key)entry.getKey()).getName()).process(castedMap);
                        this.modules.put(moduleConfig.name, (Object)moduleConfig);
                    } else {
                        logger.warn("The [runtime.modules.{}] configuration is not a JSON Object, ignoring it.", entry.getKey());
                    }
                });
            } else {
                logger.warn("The [runtime.modules] configuration is not a JSON Object, ignoring it.");
            }
        }
        if (config.containsKey(Key.security)) {
            this.security.process(StructCaster.cast(config.get(Key.security)));
        }
        return this;
    }

    public String[] getRegisteredMappings() {
        return (String[])this.mappings.keySet().stream().map(Key::getName).toArray(String[]::new);
    }

    public boolean hasMapping(String mapping) {
        return this.hasMapping(Key.of(mapping));
    }

    public boolean hasMapping(Key mapping) {
        if (!mapping.getName().startsWith("/")) {
            mapping = Key.of("/" + mapping.getName());
        }
        return this.mappings.containsKey(mapping);
    }

    public Configuration registerMapping(String mapping, String path) {
        return this.registerMapping(Key.of(mapping), path);
    }

    public Configuration registerMapping(Key mapping, String path) {
        Path pathObj;
        if (!mapping.getName().startsWith("/")) {
            mapping = Key.of("/" + mapping.getName());
        }
        if (!(pathObj = Path.of(path, new String[0]).toAbsolutePath()).toFile().exists()) {
            throw new BoxRuntimeException(String.format("The path [%s] does not exist.", pathObj));
        }
        this.mappings.put(mapping, (Object)pathObj.toString());
        return this;
    }

    public boolean unregisterMapping(String mapping) {
        return this.unregisterMapping(Key.of(mapping));
    }

    public boolean unregisterMapping(Key mapping) {
        if (!mapping.getName().startsWith("/")) {
            mapping = Key.of("/" + mapping.getName());
        }
        return this.mappings.remove(mapping) != null;
    }

    public URL[] getJavaLibraryPaths() {
        return (URL[])this.javaLibraryPaths.stream().filter(path -> Paths.get(path, new String[0]).toFile().exists()).map(path -> {
            try {
                Path targetPath = Paths.get(path, new String[0]);
                if (Files.isDirectory(targetPath, new LinkOption[0])) {
                    return DynamicClassLoader.getJarURLs(targetPath);
                }
                return new URL[]{targetPath.toUri().toURL()};
            }
            catch (IOException e) {
                throw new BoxIOException(path + " is not a valid path", e);
            }
        }).flatMap(Arrays::stream).distinct().toArray(URL[]::new);
    }

    public void validateDatsourceDrivers() {
        this.datasources.entrySet().forEach(entry -> {
            DatasourceConfig datasource = (DatasourceConfig)entry.getValue();
            if (!BoxRuntime.getInstance().getDataSourceService().hasDriver(datasource.getDriver()).booleanValue()) {
                throw new BoxRuntimeException(String.format("The datasource [%s] has a driver [%s] that is not registered with the datasource service.", datasource.name, datasource.getDriver()));
            }
        });
    }

    public DataNavigator.Navigator navigate(String ... path) {
        return DataNavigator.of(this.asStruct()).from(path);
    }

    public Set<String> getValidExtensions() {
        HashSet<String> extensions = new HashSet<String>();
        extensions.addAll(this.validClassExtensions);
        extensions.addAll(this.validTemplateExtensions);
        return extensions;
    }

    public List<String> getValidTemplateExtensionsList() {
        return new ArrayList<String>(this.validTemplateExtensions);
    }

    public List<String> getValidClassExtensionsList() {
        return new ArrayList<String>(this.validClassExtensions);
    }

    @Override
    public IStruct asStruct() {
        Struct mappingsCopy = new Struct(Struct.KEY_LENGTH_LONGEST_FIRST_COMPARATOR);
        mappingsCopy.putAll(this.mappings);
        Struct cachesCopy = new Struct();
        this.caches.entrySet().forEach(entry -> cachesCopy.put((Key)entry.getKey(), (Object)((CacheConfig)entry.getValue()).toStruct()));
        Struct executorsCopy = new Struct();
        this.executors.entrySet().forEach(entry -> executorsCopy.put((Key)entry.getKey(), (Object)((ExecutorConfig)entry.getValue()).toStruct()));
        Struct datsourcesCopy = new Struct();
        this.datasources.entrySet().forEach(entry -> datsourcesCopy.put((Key)entry.getKey(), (Object)((DatasourceConfig)entry.getValue()).asStruct()));
        Struct modulesCopy = new Struct();
        this.modules.entrySet().forEach(entry -> modulesCopy.put((Key)entry.getKey(), (Object)((ModuleConfig)entry.getValue()).asStruct()));
        return Struct.of(Key.applicationTimeout, this.applicationTimeout, Key.caches, cachesCopy, Key.classGenerationDirectory, this.classGenerationDirectory, Key.customTagsDirectory, Array.fromList(this.customTagsDirectory), Key.datasources, datsourcesCopy, Key.debugMode, this.debugMode, Key.defaultCache, this.defaultCache.toStruct(), Key.defaultDatasource, this.defaultDatasource, Key.defaultRemoteMethodReturnFormat, this.defaultRemoteMethodReturnFormat, Key.executors, executorsCopy, Key.experimental, Struct.fromMap(this.experimental), Key.invokeImplicitAccessor, this.invokeImplicitAccessor, Key.javaLibraryPaths, Array.fromList(this.javaLibraryPaths), Key.locale, this.locale, Key.mappings, mappingsCopy, Key.modules, modulesCopy, Key.modulesDirectory, Array.fromList(this.modulesDirectory), Key.originalConfig, this.originalConfig, Key.requestTimeout, this.requestTimeout, Key.sessionManagement, this.sessionManagement, Key.sessionStorage, this.sessionStorage, Key.sessionTimeout, this.sessionTimeout, Key.setClientCookies, this.setClientCookies, Key.setDomainCookies, this.setDomainCookies, Key.security, this.security.asStruct(), Key.timezone, this.timezone, Key.useHighPrecisionMath, this.useHighPrecisionMath, Key.validExtensions, Array.fromSet(this.getValidExtensions()), Key.validClassExtensions, Array.fromSet(this.validClassExtensions), Key.validTemplateExtensions, Array.fromSet(this.validTemplateExtensions));
    }
}

