/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.config.segments;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;

public class CacheConfig {
    public Key name = Key._DEFAULT;
    public Key provider = Key.boxCacheProvider;
    public IStruct properties = new Struct(DEFAULTS);
    public static final IStruct DEFAULTS = Struct.of(new Object[]{"evictCount", 1, "evictionPolicy", "LRU", "freeMemoryPercentageThreshold", 0, "maxObjects", 1000, "defaultLastAccessTimeout", 1800, "defaultTimeout", 3600, "objectStore", "ConcurrentStore", "reapFrequency", 120, "resetTimeoutOnAccess", false, "useLastAccessTimeouts", true});
    private static final Logger logger = LoggerFactory.getLogger(CacheConfig.class);

    public CacheConfig() {
    }

    public CacheConfig(Key name, Key provider, IStruct properties) {
        this.name = name;
        this.provider = provider;
        this.processProperties(properties);
    }

    public CacheConfig(Key name, IStruct properties) {
        this(name, Key.boxCacheProvider, properties);
    }

    public CacheConfig(Key name) {
        this(name, new Struct());
    }

    public CacheConfig(String name) {
        this(Key.of(name));
    }

    public CacheConfig process(IStruct config) {
        if (config.containsKey("name")) {
            this.name = Key.of((String)config.get("name"));
        }
        if (config.containsKey("provider")) {
            this.provider = Key.of((String)config.get("provider"));
        }
        if (config.containsKey("properties")) {
            Object object = config.get("properties");
            if (object instanceof Map) {
                Map castedProps = (Map)object;
                this.processProperties(new Struct(castedProps));
            } else {
                logger.warn("The [runtime.caches.{}.properties] configuration is not a JSON Object, ignoring it.", (Object)this.name);
            }
        }
        return this;
    }

    public CacheConfig processProperties(IStruct properties) {
        this.properties = properties;
        if (this.provider.equals(Key.boxCacheProvider)) {
            DEFAULTS.entrySet().stream().forEach(entry -> this.properties.putIfAbsent((Key)entry.getKey(), entry.getValue()));
        }
        return this;
    }

    public IStruct toStruct() {
        return Struct.of(new Object[]{"name", this.name.getName(), "provider", this.provider.getName(), "properties", new Struct(this.properties)});
    }
}

