/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.config.segments;

import com.zaxxer.hikari.HikariConfig;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.config.segments.IConfigSegment;
import ortus.boxlang.runtime.config.util.PlaceholderHelper;
import ortus.boxlang.runtime.dynamic.casters.IntegerCaster;
import ortus.boxlang.runtime.dynamic.casters.LongCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.jdbc.drivers.IJDBCDriver;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.DatasourceService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.util.StructUtil;

public class DatasourceConfig
implements Comparable<DatasourceConfig>,
IConfigSegment {
    public static final String DATASOURCE_PREFIX = "bx_";
    public static final String ON_THE_FLY_PREFIX = "onthefly_";
    public Key name;
    public Key applicationName = Key._EMPTY;
    public boolean onTheFly = false;
    public IStruct properties = new Struct(DEFAULTS);
    private static final List<Key> CONNECTION_STRING_KEYS = List.of(Key.connectionString, Key.dsn, Key.URL, Key.jdbcURL);
    private static final IStruct DEFAULTS = Struct.of(new Object[]{"maxConnections", 10, "minConnections", 10, "connectionTimeout", 1, "idleTimeout", 600, "maxLifetime", 1800, "keepaliveTime", 600, "autoCommit", true, "registerMbeans", true, "custom", new Struct()});
    private List<Key> RESERVED_CONNECTION_PROPERTIES = List.of(Key.autoCommit, Key.connectionString, Key.connectionTestQuery, Key.connectionTimeout, Key.driver, Key.dsn, Key.healthCheckRegistry, Key.host, Key.idleTimeout, Key.jdbcURL, Key.keepaliveTime, Key.maxConnections, Key.maxLifetime, Key.metricRegistry, Key.minConnections, Key.password, Key.poolName, Key.port, Key.username);
    private static final Logger logger = LoggerFactory.getLogger(DatasourceConfig.class);

    public DatasourceConfig() {
    }

    public DatasourceConfig(String name, IStruct properties) {
        this(Key.of(name), properties);
    }

    public DatasourceConfig(Key name, IStruct properties) {
        this.name = name;
        this.processProperties(properties);
    }

    public DatasourceConfig(IStruct properties) {
        this.processProperties(properties);
        this.name = Key.of("unnamed_" + UUID.randomUUID().toString());
    }

    public DatasourceConfig(Key name) {
        this.name = name;
    }

    public DatasourceConfig(String name) {
        this(Key.of(name));
    }

    public static String discoverDriverFromJdbcUrl(String jdbcURL) {
        logger.debug("Attempting to determine driver from JDBC URL: {}", (Object)jdbcURL);
        if (jdbcURL == null || jdbcURL.isEmpty() || !jdbcURL.contains(":") || !jdbcURL.startsWith("jdbc:")) {
            return "";
        }
        String parsedDriver = jdbcURL.split(":")[1];
        logger.debug("Parsed {} driver from {}", (Object)parsedDriver, (Object)jdbcURL);
        return parsedDriver;
    }

    public Boolean isOnTheFly() {
        return this.onTheFly;
    }

    public DatasourceConfig setOnTheFly() {
        this.onTheFly = true;
        return this;
    }

    public DatasourceConfig withAppName(Key appName) {
        this.applicationName = appName;
        return this;
    }

    public Key getUniqueName() {
        StringBuilder uniqueName = new StringBuilder(DATASOURCE_PREFIX);
        if (!this.applicationName.isEmpty()) {
            uniqueName.append(this.applicationName.toString());
            uniqueName.append("_");
        }
        if (this.onTheFly) {
            uniqueName.append(ON_THE_FLY_PREFIX);
        }
        uniqueName.append(this.name.toString());
        uniqueName.append("_");
        uniqueName.append(this.properties.hashCode());
        return Key.of(uniqueName.toString());
    }

    public String getOriginalName() {
        return this.name.getName();
    }

    @Override
    public DatasourceConfig process(IStruct config) {
        Object object;
        if (config.containsKey("name")) {
            this.name = Key.of((String)config.get("name"));
        }
        if (config.containsKey("applicationName")) {
            this.applicationName = Key.of((String)config.get("applicationName"));
        }
        if (config.containsKey("onTheFly")) {
            this.onTheFly = config.getAsBoolean(Key.of("onTheFly"));
        }
        if (config.containsKey("properties") && (object = config.get("properties")) instanceof Map) {
            Map castedProperties = (Map)object;
            this.processProperties(new Struct(castedProperties));
        } else {
            this.processProperties(config);
        }
        return this;
    }

    public DatasourceConfig processProperties(IStruct properties) {
        String driver;
        properties.entrySet().stream().forEach(entry -> {
            Object patt0$temp = entry.getValue();
            if (patt0$temp instanceof String) {
                String castedValue = (String)patt0$temp;
                this.properties.put((Key)entry.getKey(), (Object)PlaceholderHelper.resolve(castedValue));
            } else {
                this.properties.put((Key)entry.getKey(), entry.getValue());
            }
        });
        DEFAULTS.entrySet().stream().forEach(entry -> this.properties.putIfAbsent((Key)entry.getKey(), entry.getValue()));
        if (this.properties.containsKey(Key.dbdriver)) {
            this.properties.computeIfAbsent(Key.driver, key -> this.properties.get(Key.dbdriver));
        }
        if (this.properties.containsKey(Key.type)) {
            this.properties.computeIfAbsent(Key.driver, key -> this.properties.get(Key.type));
        }
        if ((driver = this.properties.getOrDefault(Key.driver, (Object)"").toString()).isBlank()) {
            this.properties.put(Key.driver, (Object)DatasourceConfig.discoverDriverFromJdbcUrl(this.getConnectionString()));
        }
        return this;
    }

    public Key getDriver() {
        return Key.of(this.properties.getOrDefault(Key.driver, (Object)"").toString());
    }

    @Override
    public IStruct asStruct() {
        return Struct.of(new Object[]{"applicationName", this.applicationName.getName(), "name", this.name.getName(), "onTheFly", this.onTheFly, "uniqueName", this.getUniqueName().getName(), "properties", new Struct(this.properties)});
    }

    public int hashCode() {
        return this.getUniqueName().hashCode();
    }

    @Override
    public int compareTo(DatasourceConfig otherConfig) {
        return this.getUniqueName().compareTo(otherConfig.getUniqueName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DatasourceConfig other = (DatasourceConfig)obj;
        return this.getUniqueName().equals(other.getUniqueName());
    }

    public HikariConfig toHikariConfig() {
        if (this.properties.getOrDefault(Key.driver, (Object)"").toString().isBlank()) {
            throw new IllegalArgumentException("Datasource configuration must contain a 'driver', or a valid JDBC connection string in 'url'.");
        }
        DatasourceService datasourceService = BoxRuntime.getInstance().getDataSourceService();
        HikariConfig result = new HikariConfig();
        IJDBCDriver driverOrDefault = datasourceService.hasDriver(this.getDriver()) != false ? datasourceService.getDriver(this.getDriver()) : datasourceService.getGenericDriver();
        driverOrDefault.getDefaultProperties().entrySet().stream().forEach(entry -> this.properties.putIfAbsent((Key)entry.getKey(), entry.getValue()));
        Object v = this.properties.get(Key.custom);
        if (v instanceof String) {
            String castedCustomParams = (String)v;
            this.properties.put(Key.custom, (Object)StructUtil.fromQueryString(castedCustomParams));
        }
        result.setJdbcUrl(this.getOrBuildConnectionString(driverOrDefault));
        if (this.properties.containsKey(Key.username)) {
            result.setUsername(this.properties.getAsString(Key.username));
        }
        if (this.properties.containsKey(Key.password)) {
            result.setPassword(this.properties.getAsString(Key.password));
        }
        if (this.properties.containsKey(Key.connectionTimeout)) {
            result.setConnectionTimeout(LongCaster.cast(this.properties.get(Key.connectionTimeout), false) * 1000L);
        }
        if (this.properties.containsKey(Key.minConnections)) {
            result.setMinimumIdle(IntegerCaster.cast(this.properties.get(Key.minConnections), false));
        }
        if (this.properties.containsKey(Key.maxConnections)) {
            result.setMaximumPoolSize(IntegerCaster.cast(this.properties.get(Key.maxConnections), false));
        }
        if (this.properties.containsKey(Key.autoCommit)) {
            result.setAutoCommit(this.properties.getAsBoolean(Key.autoCommit));
        }
        if (this.properties.containsKey(Key.idleTimeout)) {
            result.setIdleTimeout(LongCaster.cast(this.properties.get(Key.idleTimeout), false) * 1000L);
        }
        if (this.properties.containsKey(Key.keepaliveTime)) {
            result.setKeepaliveTime(LongCaster.cast(this.properties.get(Key.keepaliveTime), false) * 1000L);
        }
        if (this.properties.containsKey(Key.maxLifetime)) {
            result.setMaxLifetime(LongCaster.cast(this.properties.get(Key.maxLifetime), false) * 1000L);
        }
        if (this.properties.containsKey(Key.connectionTestQuery)) {
            result.setConnectionTestQuery(this.properties.getAsString(Key.connectionTestQuery));
        }
        if (this.properties.containsKey(Key.metricRegistry)) {
            result.setMetricRegistry(this.properties.getAsString(Key.metricRegistry));
        }
        if (this.properties.containsKey(Key.healthCheckRegistry)) {
            result.setHealthCheckRegistry(this.properties.getAsString(Key.healthCheckRegistry));
        }
        if (this.properties.containsKey(Key.poolName)) {
            result.setPoolName(this.properties.getAsString(Key.poolName));
        }
        this.properties.entrySet().stream().filter(entry -> !this.RESERVED_CONNECTION_PROPERTIES.contains(entry.getKey())).forEach(entry -> result.addDataSourceProperty(((Key)entry.getKey()).getName(), entry.getValue()));
        return result;
    }

    private String getOrBuildConnectionString(IJDBCDriver driver) {
        String connectionString = this.getConnectionString();
        if (connectionString.isBlank()) {
            connectionString = driver.buildConnectionURL(this);
        }
        return this.replaceConnectionPlaceholders(connectionString);
    }

    public String addCustomParams(String target, String delimiter) {
        String castedCustom;
        String targetCustom = "";
        Object v = this.properties.get(Key.custom);
        targetCustom = v instanceof String ? (castedCustom = (String)v) : StructUtil.toQueryString((IStruct)this.properties.get(Key.custom), delimiter);
        if (targetCustom.length() > 0) {
            if (((String)target).contains("?") && !((String)target).endsWith("?")) {
                target = (String)target + delimiter;
            } else if (!((String)target).contains("?")) {
                target = (String)target + "?";
            }
            target = (String)target + targetCustom;
        }
        return target;
    }

    public String addCustomParams(String target) {
        return this.addCustomParams(target, "&");
    }

    private String replaceConnectionPlaceholders(String target) {
        target = target.replace("{host}", (String)this.properties.getOrDefault(Key.host, (Object)"NOT_FOUND"));
        target = target.replace("{port}", StringCaster.cast(this.properties.getOrDefault(Key.port, (Object)0), true));
        target = target.replace("{database}", (String)this.properties.getOrDefault(Key.database, (Object)"NOT_FOUND"));
        return target;
    }

    private String getConnectionString() {
        return CONNECTION_STRING_KEYS.stream().filter(key -> this.properties.containsKey((Key)key) && !this.properties.getAsString((Key)key).isBlank()).findFirst().map(key -> this.addCustomParams(this.properties.getAsString((Key)key))).orElse("");
    }
}

