/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.config.segments;

import ortus.boxlang.runtime.config.util.PlaceholderHelper;
import ortus.boxlang.runtime.dynamic.casters.IntegerCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;

public class ExecutorConfig {
    public String name;
    public String type = "FIXED";
    public int maxThreads = 20;

    public ExecutorConfig() {
    }

    public ExecutorConfig(String name) {
        this.name = name;
    }

    public ExecutorConfig(Key name) {
        this.name = name.getName();
    }

    public ExecutorConfig process(IStruct config) {
        if (config.containsKey("name")) {
            this.name = PlaceholderHelper.resolve(config.get("name"));
        }
        if (config.containsKey("type")) {
            this.type = PlaceholderHelper.resolve(config.get("type")).toUpperCase();
        }
        if (config.containsKey("maxThreads")) {
            this.maxThreads = IntegerCaster.cast(PlaceholderHelper.resolve(config.get("maxThreads")));
        }
        return this;
    }

    public IStruct toStruct() {
        return Struct.of(new Object[]{"name", this.name, "type", this.type, "maxThreads", this.maxThreads});
    }
}

