/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.config.segments;

import ortus.boxlang.runtime.config.segments.IConfigSegment;
import ortus.boxlang.runtime.config.util.PlaceholderHelper;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;

public class ModuleConfig
implements IConfigSegment {
    public String name;
    public Boolean disabled = false;
    public IStruct settings = new Struct();

    public ModuleConfig(String name) {
        this.name = name;
    }

    @Override
    public ModuleConfig process(IStruct config) {
        if (config.containsKey("disabled")) {
            this.disabled = BooleanCaster.cast(PlaceholderHelper.resolve(config.getOrDefault("disabled", (Object)false)));
        }
        this.settings = StructCaster.cast(config.getOrDefault(Key.settings, (Object)new Struct()));
        this.settings.forEach((key, value) -> {
            if (value instanceof String) {
                this.settings.put((Key)key, (Object)PlaceholderHelper.resolve(value));
            } else {
                this.settings.put((Key)key, value);
            }
        });
        return this;
    }

    @Override
    public IStruct asStruct() {
        return Struct.of(new Object[]{Key._NAME, this.name, Key.disabled, this.disabled, Key.settings, new Struct(this.settings)});
    }
}

