/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.config.segments;

import com.google.common.io.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.config.segments.IConfigSegment;
import ortus.boxlang.runtime.config.util.PropertyHelper;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;

public class SecurityConfig
implements IConfigSegment {
    public Set<String> disallowedImports = new HashSet<String>();
    public Set<String> disallowedBIFs = new HashSet<String>();
    public Set<String> disallowedComponents = new HashSet<String>();
    public List<String> allowedFileOperationExtensions = new ArrayList<String>();
    public List<String> disallowedFileOperationExtensions = new ArrayList<String>();
    private static final Logger logger = LoggerFactory.getLogger(SecurityConfig.class);
    public Map<String, Boolean> allowedBIFsLookup = new ConcurrentHashMap<String, Boolean>();
    public Map<String, Boolean> allowedComponentsLookup = new ConcurrentHashMap<String, Boolean>();
    public Map<String, Boolean> allowedImportsLookup = new ConcurrentHashMap<String, Boolean>();

    public boolean isBIFAllowed(String name) {
        if (this.allowedBIFsLookup.containsKey(name)) {
            return true;
        }
        if (this.disallowedBIFs.stream().anyMatch(name::equalsIgnoreCase)) {
            throw new SecurityException("The BIF '" + name + "' is disallowed, please check your security configuration in the language configuration file.");
        }
        this.allowedBIFsLookup.put(name, true);
        return true;
    }

    public boolean isComponentAllowed(String name) {
        if (this.allowedComponentsLookup.containsKey(name)) {
            return true;
        }
        if (this.disallowedComponents.stream().anyMatch(name::equalsIgnoreCase)) {
            throw new SecurityException("The Component '" + name + "' is disallowed, please check your security configuration in the language configuration file.");
        }
        this.allowedComponentsLookup.put(name, true);
        return true;
    }

    public boolean isClassAllowed(String name) {
        if (this.allowedImportsLookup.containsKey(name)) {
            return true;
        }
        if (this.disallowedImports.stream().anyMatch(name::matches)) {
            throw new SecurityException("The class '" + name + "' is disallowed, please check your security configuration in the language configuration file.");
        }
        this.allowedImportsLookup.put(name, true);
        return true;
    }

    public boolean isFileOperationAllowed(String file) {
        String fileExtension = Files.getFileExtension(file);
        return this.isExtensionAllowed(fileExtension);
    }

    public boolean isExtensionAllowed(String extension) {
        if (this.allowedFileOperationExtensions.contains(extension)) {
            return true;
        }
        return !this.disallowedFileOperationExtensions.contains(extension);
    }

    @Override
    public IConfigSegment process(IStruct config) {
        PropertyHelper.processListToSet(config, Key.disallowedImports, this.disallowedImports);
        PropertyHelper.processListToSet(config, Key.disallowedBIFs, this.disallowedBIFs);
        PropertyHelper.processListToSet(config, Key.disallowedComponents, this.disallowedComponents);
        PropertyHelper.processStringOrArrayToList(config, Key.allowedFileOperationExtensions, this.allowedFileOperationExtensions);
        PropertyHelper.processStringOrArrayToList(config, Key.disallowedFileOperationExtensions, this.disallowedFileOperationExtensions);
        return this;
    }

    @Override
    public IStruct asStruct() {
        return Struct.of(new Object[]{Key.allowedFileOperationExtensions, Array.fromList(this.allowedFileOperationExtensions), Key.disallowedImports, this.disallowedImports, Key.disallowedBIFs, this.disallowedBIFs, Key.disallowedComponents, this.disallowedComponents, Key.disallowedFileOperationExtensions, Array.fromList(this.disallowedFileOperationExtensions)});
    }
}

