/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.config.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class PlaceholderHelper {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("(?i)\\$\\{([^:}]+)(?::([^}]+))?\\}");
    private static final IStruct PLACEHOLDER_MAP = new Struct();

    public static String resolve(String input, IStruct map) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(input);
        return matcher.replaceAll(matchResult -> {
            String defaultValue;
            String placeholder = matchResult.group(1);
            String replacement = (String)map.getOrDefault(placeholder, (Object)((defaultValue = matchResult.group(2)) != null ? defaultValue : matchResult.group()));
            if (replacement == null) {
                throw new BoxRuntimeException("Placeholder '" + placeholder + "' has no replacement value. Value values are " + map.asString() + ". Replacement code was: " + input);
            }
            return Matcher.quoteReplacement(replacement);
        });
    }

    public static String resolve(String input, Map<String, String> map) {
        return PlaceholderHelper.resolve(input, (IStruct)new Struct(map));
    }

    public static String resolve(Object input, Map<String, String> map) {
        return PlaceholderHelper.resolve(StringCaster.cast(input), map);
    }

    public static String resolve(Object input, IStruct map) {
        return PlaceholderHelper.resolve(StringCaster.cast(input), map);
    }

    public static String resolve(String input) {
        return PlaceholderHelper.resolve(input, PLACEHOLDER_MAP);
    }

    public static String resolve(Object input) {
        return PlaceholderHelper.resolve(StringCaster.cast(input));
    }

    private static String escapeReplacementMetaChars(String input) {
        return input.replaceAll("([\\\\$])", "\\\\$1");
    }

    static {
        PLACEHOLDER_MAP.put("user-home", (Object)System.getProperty("user.home"));
        PLACEHOLDER_MAP.put("java-temp", (Object)System.getProperty("java.io.tmpdir"));
        PLACEHOLDER_MAP.put("user-dir", (Object)System.getProperty("user.dir"));
        PLACEHOLDER_MAP.put("boxlang-home", (Object)BoxRuntime.getInstance().getRuntimeHome().toString());
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            PLACEHOLDER_MAP.put("env." + entry.getKey(), (Object)entry.getValue());
        }
    }
}

