/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.config.util;

import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.config.util.PlaceholderHelper;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.util.ListUtil;

public class PropertyHelper {
    private static final Logger logger = LoggerFactory.getLogger(PropertyHelper.class);

    public static void processListToSet(IStruct config, Key key, Set<String> target) {
        if (config.containsKey(key)) {
            Object v = config.get(key);
            if (v instanceof List) {
                List castedList = (List)v;
                target.addAll(castedList);
            } else {
                logger.warn("The property [{}] must be a JSON Array", (Object)key);
            }
        }
    }

    public static void processStringOrArrayToList(IStruct config, Key key, List<String> target) {
        if (config.containsKey(key)) {
            Object v = config.get(key);
            if (v instanceof String) {
                String castedStringList = (String)v;
                config.put(key, (Object)ListUtil.asList(PlaceholderHelper.resolve(castedStringList), ","));
            }
            ArrayCaster.cast(config.get(key)).stream().map(StringCaster::cast).forEach(target::add);
        }
    }
}

