/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.context;

import ortus.boxlang.runtime.application.Application;
import ortus.boxlang.runtime.context.BaseBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ApplicationScope;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;

public class ApplicationBoxContext
extends BaseBoxContext {
    protected Application application;
    protected IScope applicationScope;

    public ApplicationBoxContext(Application application) {
        this(null, application);
    }

    public ApplicationBoxContext(IBoxContext parent, Application application) {
        super(parent);
        this.updateApplication(application);
    }

    public Application getApplication() {
        return this.application;
    }

    public IScope getApplicationScope() {
        return this.applicationScope;
    }

    public void updateApplication(Application application) {
        this.application = application;
        this.applicationScope = application.getApplicationScope();
        this.applicationScope.put(Key.applicationName, (Object)application.getName());
    }

    @Override
    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (this.hasParent().booleanValue() && !shallow) {
            this.getParent().getVisibleScopes(scopes, false, false);
        }
        scopes.getAsStruct(Key.contextual).put(ApplicationScope.name, (Object)this.applicationScope);
        return scopes;
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope, boolean shallow) {
        if (shallow) {
            return null;
        }
        return this.scopeFind(key, defaultScope);
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFind(Key key, IScope defaultScope) {
        if (key.equals(this.applicationScope.getName())) {
            return new IBoxContext.ScopeSearchResult(this.applicationScope, this.applicationScope, key, true);
        }
        return this.parent.scopeFind(key, defaultScope);
    }

    @Override
    public IScope getScope(Key name) throws ScopeNotFoundException {
        if (name.equals(this.applicationScope.getName())) {
            return this.applicationScope;
        }
        return this.parent.getScope(name);
    }

    @Override
    public IScope getScopeNearby(Key name, boolean shallow) throws ScopeNotFoundException {
        if (shallow) {
            return null;
        }
        return this.getScope(name);
    }
}

