/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.context;

import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.BIFDescriptor;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.components.ComponentDescriptor;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.FunctionCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.loader.ImportDefinition;
import ortus.boxlang.runtime.modules.ModuleRecord;
import ortus.boxlang.runtime.runnables.BoxInterface;
import ortus.boxlang.runtime.runnables.BoxTemplate;
import ortus.boxlang.runtime.runnables.IBoxRunnable;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.runnables.RunnableLoader;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.ComponentService;
import ortus.boxlang.runtime.services.FunctionService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.QueryColumn;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.UDF;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.KeyNotFoundException;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;
import ortus.boxlang.runtime.util.Attachable;
import ortus.boxlang.runtime.util.DataNavigator;
import ortus.boxlang.runtime.util.IBoxAttachable;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public class BaseBoxContext
implements IBoxContext {
    private static final ThreadLocal<Integer> flushBufferDepth = ThreadLocal.withInitial(() -> 0);
    protected IBoxContext parent;
    protected ArrayDeque<ResolvedFilePath> templates = new ArrayDeque();
    protected List<ImportDefinition> currentImports = null;
    protected ArrayDeque<IStruct> components = new ArrayDeque();
    protected LinkedHashMap<Query, Integer> queryLoops = new LinkedHashMap();
    protected ArrayDeque<StringBuffer> buffers = new ArrayDeque();
    private final FunctionService functionService;
    private final ComponentService componentService;
    private final IBoxAttachable attachable = new Attachable();

    public BaseBoxContext(IBoxContext parent) {
        this.parent = parent;
        this.functionService = BoxRuntime.getInstance().getFunctionService();
        this.componentService = BoxRuntime.getInstance().getComponentService();
        this.buffers.push(new StringBuffer());
    }

    public BaseBoxContext() {
        this(null);
    }

    @Override
    public IBoxContext pushTemplate(IBoxRunnable template) {
        this.pushTemplate(template.getRunnablePath());
        this.currentImports = template.getImports();
        return this;
    }

    @Override
    public IBoxContext pushTemplate(ResolvedFilePath template) {
        this.templates.push(template);
        return this;
    }

    @Override
    public ResolvedFilePath popTemplate() {
        return this.templates.pop();
    }

    @Override
    public ResolvedFilePath[] getTemplates() {
        return this.templates.toArray(new ResolvedFilePath[0]);
    }

    @Override
    public IBoxContext pushComponent(IStruct executionState) {
        this.components.push(executionState);
        return this;
    }

    @Override
    public IBoxContext popComponent() {
        this.components.pop();
        return this;
    }

    @Override
    public IStruct findClosestComponent(Key name) {
        return this.findClosestComponent(name, null);
    }

    @Override
    public IStruct findClosestComponent(Key name, Predicate<IStruct> predicate) {
        IStruct[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            IStruct component = componentArray[i];
            if (!component.get(Key._NAME).equals(name) || predicate != null && !predicate.test(component)) continue;
            return component;
        }
        return null;
    }

    @Override
    public IStruct[] getComponents() {
        if (this.hasParent().booleanValue()) {
            IStruct[] parentComponents = this.getParent().getComponents();
            IStruct[] myComponents = this.components.toArray(new IStruct[0]);
            IStruct[] allComponents = new IStruct[parentComponents.length + myComponents.length];
            System.arraycopy(myComponents, 0, allComponents, 0, myComponents.length);
            System.arraycopy(parentComponents, 0, allComponents, myComponents.length, parentComponents.length);
            return allComponents;
        }
        return this.components.toArray(new IStruct[0]);
    }

    @Override
    public boolean hasTemplates() {
        return !this.templates.isEmpty();
    }

    @Override
    public ResolvedFilePath findClosestTemplate() {
        if (this.hasTemplates()) {
            return this.templates.peek();
        }
        if (this.hasParent().booleanValue()) {
            return this.getParent().findClosestTemplate();
        }
        return null;
    }

    @Override
    public ResolvedFilePath findBaseTemplate() {
        ResolvedFilePath result = null;
        if (this.hasParent().booleanValue() && (result = this.getParent().findBaseTemplate()) != null) {
            return result;
        }
        if (this.hasTemplates()) {
            return this.templates.peekLast();
        }
        return null;
    }

    @Override
    public void rethrow() {
        if (this.hasParent().booleanValue()) {
            this.getParent().rethrow();
        }
        throw new BoxRuntimeException("No exception to rethrow.  You can only rethrow inside of a catch block.");
    }

    @Override
    public IBoxContext getParent() {
        return this.parent;
    }

    @Override
    public IBoxContext setParent(IBoxContext parentContext) {
        this.parent = parentContext;
        return this;
    }

    @Override
    public IBoxContext injectParentContext(IBoxContext parentContext) {
        parentContext.setParent(this.getParent());
        this.setParent(parentContext);
        return this;
    }

    @Override
    public IBoxContext injectTopParentContext(IBoxContext parentContext) {
        RequestBoxContext requestContext = this.getParentOfType(RequestBoxContext.class);
        if (requestContext == null) {
            return this.injectParentContext(parentContext);
        }
        requestContext.injectParentContext(parentContext);
        return this;
    }

    @Override
    public IBoxContext removeParentContext(Class<? extends IBoxContext> type) {
        if (this.hasParent().booleanValue()) {
            if (type.isInstance(this.getParent())) {
                this.setParent(this.getParent().getParent());
            } else {
                this.getParent().removeParentContext(type);
            }
        }
        return this;
    }

    @Override
    public Boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public Object invokeFunction(Key name, Object[] positionalArguments) {
        BIFDescriptor bif = this.findBIF(name);
        if (bif != null) {
            return bif.invoke((IBoxContext)this, positionalArguments, false, name);
        }
        ortus.boxlang.runtime.types.Function function = this.findFunction(name);
        if (function == null) {
            throw new BoxRuntimeException("Function '" + name.getName() + "' not found");
        }
        return this.invokeFunction(function, name, positionalArguments);
    }

    @Override
    public Object invokeFunction(Key name, Map<Key, Object> namedArguments) {
        BIFDescriptor bif = this.findBIF(name);
        if (bif != null) {
            return bif.invoke((IBoxContext)this, namedArguments, false, name);
        }
        ortus.boxlang.runtime.types.Function function = this.findFunction(name);
        if (function == null) {
            throw new BoxRuntimeException("Function '" + name.getName() + "' not found");
        }
        return this.invokeFunction(function, name, namedArguments);
    }

    @Override
    public Object invokeFunction(Key name) {
        BIFDescriptor bif = this.findBIF(name);
        if (bif != null) {
            return bif.invoke(this, false);
        }
        ortus.boxlang.runtime.types.Function function = this.findFunction(name);
        if (function == null) {
            throw new BoxRuntimeException("Function '" + name.getName() + "' not found");
        }
        return this.invokeFunction(function, name, new Object[0]);
    }

    @Override
    public Component.BodyResult invokeComponent(Key name, IStruct attributes, Component.ComponentBody componentBody) {
        this.getRuntime().getConfiguration().security.isComponentAllowed(name.getName());
        ComponentDescriptor comp = this.componentService.getComponent(name);
        if (comp != null) {
            return comp.invoke(this, attributes, componentBody);
        }
        throw new BoxRuntimeException("Component [" + name.getName() + "] could not be found.");
    }

    @Override
    public Object invokeFunction(Object function, Object[] positionalArguments) {
        ortus.boxlang.runtime.types.Function func = FunctionCaster.cast(function);
        return this.invokeFunction(func, func.getName(), positionalArguments);
    }

    protected BIFDescriptor findBIF(Key name) {
        this.getRuntime().getConfiguration().security.isBIFAllowed(name.getName());
        return this.functionService.getGlobalFunction(name);
    }

    @Override
    public Object invokeFunction(Object function, Map<Key, Object> namedArguments) {
        ortus.boxlang.runtime.types.Function func = FunctionCaster.cast(function);
        return this.invokeFunction(func, func.getName(), namedArguments);
    }

    @Override
    public Object invokeFunction(Object function) {
        ortus.boxlang.runtime.types.Function func = FunctionCaster.cast(function);
        return func.invoke(ortus.boxlang.runtime.types.Function.generateFunctionContext(func, this.getFunctionParentContext(), func.getName(), new Object[0], this.getFunctionClass(), this.getFunctionInterface()));
    }

    public Object invokeFunction(ortus.boxlang.runtime.types.Function function, Key calledName, Object[] positionalArguments) {
        return function.invoke(ortus.boxlang.runtime.types.Function.generateFunctionContext(function, this.getFunctionParentContext(), calledName, positionalArguments, this.getFunctionClass(), this.getFunctionInterface()));
    }

    public Object invokeFunction(ortus.boxlang.runtime.types.Function function, Key calledName, Map<Key, Object> namedArguments) {
        return function.invoke(ortus.boxlang.runtime.types.Function.generateFunctionContext(function, this.getFunctionParentContext(), calledName, namedArguments, this.getFunctionClass(), this.getFunctionInterface()));
    }

    protected ortus.boxlang.runtime.types.Function findFunction(Key name) {
        IBoxContext.ScopeSearchResult result = null;
        try {
            result = this.scopeFindNearby(name, null);
        }
        catch (KeyNotFoundException e) {
            return null;
        }
        if (result == null) {
            return null;
        }
        CastAttempt<ortus.boxlang.runtime.types.Function> funcAttempt = FunctionCaster.attempt(result.value());
        if (funcAttempt.wasSuccessful()) {
            return funcAttempt.get();
        }
        throw new BoxRuntimeException("Variable '" + String.valueOf(name) + "' of type  '" + result.value().getClass().getName() + "'  is not a function.");
    }

    @Override
    public void includeTemplate(String templatePath) {
        BoxTemplate template = RunnableLoader.getInstance().loadTemplateRelative(this, templatePath);
        template.invoke(this);
    }

    @Override
    public IStruct getVisibleScopes() {
        IStruct scopes = Struct.linkedOf(Key.contextual, Struct.linkedOf(new Object[0]), Key.lexical, Struct.linkedOf(new Object[0]));
        return this.getVisibleScopes(scopes, true, false);
    }

    @Override
    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (this.hasParent().booleanValue() && !shallow) {
            this.getParent().getVisibleScopes(scopes, nearby, shallow);
        }
        return scopes;
    }

    @Override
    public IScope getScope(Key name) throws ScopeNotFoundException {
        throw new BoxRuntimeException("Unimplemented method 'getScope'");
    }

    @Override
    public IScope getScopeNearby(Key name, boolean shallow) throws ScopeNotFoundException {
        throw new BoxRuntimeException("Unimplemented method 'getScopeNearby'");
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFind(Key key, IScope defaultScope) {
        throw new BoxRuntimeException("Unimplemented method 'scopeFind'");
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope, boolean shallow) {
        throw new BoxRuntimeException("Unimplemented method 'scopeFindNearby'");
    }

    protected IBoxContext.ScopeSearchResult queryFindNearby(Key key) {
        if (this.queryLoops.size() > 0) {
            Query[] queries = this.queryLoops.keySet().toArray(new Query[0]);
            for (int i = queries.length - 1; i >= 0; --i) {
                Query query = queries[i];
                if (key.equals(Key.recordCount)) {
                    return new IBoxContext.ScopeSearchResult(null, query.size(), key);
                }
                if (key.equals(Key.currentRow)) {
                    return new IBoxContext.ScopeSearchResult(null, this.queryLoops.get(query) + 1, key);
                }
                if (key.equals(Key.columnList)) {
                    return new IBoxContext.ScopeSearchResult(null, query.getColumnList(), key);
                }
                if (!query.hasColumn(key)) continue;
                return new IBoxContext.ScopeSearchResult(null, query.getCell(key, this.queryLoops.get(query)), key);
            }
        }
        return null;
    }

    @Override
    public void registerUDF(UDF udf) {
        this.registerUDF(udf, true);
    }

    @Override
    public void registerUDF(UDF udf, boolean override) {
        throw new BoxRuntimeException("This context [" + this.getClass().getSimpleName() + "] cannot register a function");
    }

    @Override
    public IScope getDefaultAssignmentScope() {
        throw new BoxRuntimeException("Unimplemented method 'getDefaultAssignmentScope'");
    }

    @Override
    public Key findClosestFunctionName() {
        if (this.hasParent().booleanValue()) {
            return this.getParent().findClosestFunctionName();
        }
        return null;
    }

    @Override
    public IBoxContext getFunctionParentContext() {
        return this;
    }

    @Override
    public IClassRunnable getFunctionClass() {
        return null;
    }

    @Override
    public BoxInterface getFunctionInterface() {
        return null;
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope) {
        return this.scopeFindNearby(key, defaultScope, false);
    }

    @Override
    public IScope getScopeNearby(Key name) throws ScopeNotFoundException {
        return this.getScopeNearby(name, false);
    }

    @Override
    public List<ImportDefinition> getCurrentImports() {
        return this.currentImports;
    }

    @Override
    public Object unwrapQueryColumn(Object value) {
        if (value instanceof QueryColumn) {
            QueryColumn col = (QueryColumn)value;
            return col.getCell(this.getQueryRow(col.getQuery()));
        }
        return value;
    }

    @Override
    public int getQueryRow(Query query) {
        if (!this.queryLoops.containsKey(query)) {
            return 0;
        }
        return this.queryLoops.get(query);
    }

    @Override
    public void registerQueryLoop(Query query, int row) {
        this.queryLoops.put(query, row);
    }

    @Override
    public void unregisterQueryLoop(Query query) {
        this.queryLoops.remove(query);
    }

    @Override
    public void incrementQueryLoop(Query query) {
        this.queryLoops.put(query, this.queryLoops.get(query) + 1);
    }

    @Override
    public IBoxContext writeToBuffer(Object o, boolean force) {
        Boolean explicitOutput;
        if (o == null) {
            return this;
        }
        IStruct outputState = null;
        if (!force && (explicitOutput = (Boolean)this.getConfigItem(Key.enforceExplicitOutput, false)).booleanValue() && (outputState = this.findClosestComponent(Key.output)) == null) {
            return this;
        }
        String content = StringCaster.cast(o);
        if (outputState == null || outputState.getAsString(Key.encodefor) == null) {
            outputState = this.findClosestComponent(Key.output, state -> state.get(Key.encodefor) != null);
        }
        if (outputState != null) {
            String string = outputState.getAsString(Key.encodefor);
        }
        this.getBuffer().append(content);
        return this;
    }

    @Override
    public IBoxContext writeToBuffer(Object o) {
        return this.writeToBuffer(o, false);
    }

    @Override
    public Boolean canOutput() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBoxContext flushBuffer(boolean force) {
        if (!this.canOutput().booleanValue() && !force) {
            return this;
        }
        flushBufferDepth.set(flushBufferDepth.get() + 1);
        if (flushBufferDepth.get() > 50) {
            throw new RuntimeException("Nested flushBuffer() calls exceeded 50");
        }
        try {
            Object object;
            if (this.hasParent().booleanValue() && this.buffers.size() == 1) {
                StringBuffer thisBuffer;
                StringBuffer stringBuffer = thisBuffer = this.getBuffer();
                synchronized (stringBuffer) {
                    this.getParent().writeToBuffer(thisBuffer.toString(), true);
                    thisBuffer.setLength(0);
                }
                if (force) {
                    this.getParent().flushBuffer(true);
                }
            } else if (force && this.hasParent().booleanValue()) {
                object = this.buffers.iterator();
                while (object.hasNext()) {
                    StringBuffer buf;
                    StringBuffer stringBuffer = buf = (StringBuffer)object.next();
                    synchronized (stringBuffer) {
                        this.getParent().writeToBuffer(buf.toString(), true);
                        buf.setLength(0);
                    }
                }
                this.getParent().flushBuffer(true);
            }
            object = this;
            return object;
        }
        finally {
            flushBufferDepth.set(flushBufferDepth.get() - 1);
        }
    }

    @Override
    public IBoxContext clearBuffer() {
        this.getBuffer().setLength(0);
        if (this.hasParent().booleanValue()) {
            this.getParent().clearBuffer();
        }
        return this;
    }

    @Override
    public StringBuffer getBuffer() {
        return this.buffers.peek();
    }

    @Override
    public IBoxContext pushBuffer(StringBuffer buffer) {
        this.buffers.push(buffer);
        return this;
    }

    @Override
    public IBoxContext popBuffer() {
        this.buffers.pop();
        return this;
    }

    @Override
    public DataNavigator.Navigator navigateConfig(String ... path) {
        return DataNavigator.of(this.getConfig()).from(path);
    }

    @Override
    public IStruct getConfig() {
        if (this.hasParent().booleanValue()) {
            return this.getParent().getConfig();
        }
        return new Struct();
    }

    @Override
    public Object getConfigItem(Key itemKey) {
        return this.getConfig().get(itemKey);
    }

    @Override
    public Object getConfigItems(Key ... itemKey) {
        IStruct config = this.getConfig();
        Object lastResult = null;
        for (Key key : itemKey) {
            IStruct castedConfig;
            if (!(config instanceof IStruct) || !(castedConfig = config).containsKey(key)) break;
            lastResult = castedConfig.get(key);
            config = lastResult;
        }
        return lastResult;
    }

    @Override
    public Object getConfigItem(Key itemKey, Object defaultValue) {
        return this.getConfig().getOrDefault(itemKey, defaultValue);
    }

    @Override
    public BoxRuntime getRuntime() {
        return BoxRuntime.getInstance();
    }

    @Override
    public IStruct getModuleSettings(Key name) {
        return this.getRuntime().getModuleService().getModuleSettings(name);
    }

    @Override
    public ModuleRecord getModuleRecord(Key name) {
        return this.getRuntime().getModuleService().getModuleRecord(name);
    }

    @Override
    public <T> T getParentOfType(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (this.hasParent().booleanValue()) {
            return this.getParent().getParentOfType(type);
        }
        return null;
    }

    @Override
    public <T> T putAttachment(Key key, T value) {
        return this.attachable.putAttachment(key, value);
    }

    @Override
    public <T> T getAttachment(Key key) {
        return this.attachable.getAttachment(key);
    }

    @Override
    public boolean hasAttachment(Key key) {
        return this.attachable.hasAttachment(key);
    }

    @Override
    public <T> T removeAttachment(Key key) {
        return this.attachable.removeAttachment(key);
    }

    @Override
    public Key[] getAttachmentKeys() {
        return this.attachable.getAttachmentKeys();
    }

    @Override
    public <T> T computeAttachmentIfAbsent(Key key, Function<? super Key, ? extends T> mappingFunction) {
        return this.attachable.computeAttachmentIfAbsent(key, mappingFunction);
    }
}

