/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.context;

import java.util.Map;
import java.util.function.Predicate;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.BaseBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.ScopeWrapper;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ExceptionUtil;
import ortus.boxlang.runtime.types.exceptions.KeyNotFoundException;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;

public class CatchBoxContext
extends BaseBoxContext {
    private IScope variablesScope;
    private Throwable exception;

    public CatchBoxContext(IBoxContext parent, Key exceptionKey, Throwable exception) {
        super(parent);
        if (parent == null) {
            throw new BoxRuntimeException("Parent context cannot be null for CatchBoxContext");
        }
        this.exception = exception;
        this.variablesScope = new ScopeWrapper(parent.getScopeNearby(VariablesScope.name), Map.of(exceptionKey, exception));
    }

    @Override
    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (this.hasParent().booleanValue() && !shallow) {
            this.getParent().getVisibleScopes(scopes, false, false);
        }
        if (nearby) {
            scopes.getAsStruct(Key.contextual).put(VariablesScope.name, (Object)this.variablesScope);
        }
        return scopes;
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope, boolean shallow) {
        IBoxContext.ScopeSearchResult querySearch = this.queryFindNearby(key);
        if (querySearch != null) {
            return querySearch;
        }
        Object result = this.variablesScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.variablesScope, Struct.unWrapNull(result), key);
        }
        if (shallow) {
            return null;
        }
        if (this.parent != null) {
            return this.parent.scopeFindNearby(key, defaultScope);
        }
        return this.scopeFind(key, defaultScope);
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFind(Key key, IScope defaultScope) {
        if (this.parent != null) {
            return this.parent.scopeFind(key, defaultScope);
        }
        if (defaultScope != null) {
            return new IBoxContext.ScopeSearchResult(defaultScope, null, key);
        }
        throw new KeyNotFoundException(String.format("The requested key [%s] was not located in any scope or it's undefined", key.getName()));
    }

    @Override
    public IScope getScope(Key name) {
        if (this.parent != null) {
            return this.parent.getScopeNearby(name);
        }
        throw new ScopeNotFoundException(String.format("The requested scope name [%s] was not located in any context", name.getName()));
    }

    @Override
    public IScope getScopeNearby(Key name, boolean shallow) {
        if (name.equals(VariablesScope.name)) {
            return this.variablesScope;
        }
        if (shallow) {
            return null;
        }
        return this.getScope(name);
    }

    @Override
    public IScope getDefaultAssignmentScope() {
        return this.getParent().getDefaultAssignmentScope();
    }

    @Override
    public void rethrow() {
        ExceptionUtil.throwException(this.exception);
    }

    @Override
    public IBoxContext writeToBuffer(Object o) {
        if (o == null) {
            return this;
        }
        this.getParent().writeToBuffer(o);
        return this;
    }

    @Override
    public IBoxContext writeToBuffer(Object o, boolean force) {
        if (o == null) {
            return this;
        }
        this.getParent().writeToBuffer(o, force);
        return this;
    }

    @Override
    public Boolean canOutput() {
        return this.getParent().canOutput();
    }

    @Override
    public IBoxContext flushBuffer(boolean force) {
        this.getParent().flushBuffer(force);
        return this;
    }

    @Override
    public IBoxContext clearBuffer() {
        this.getParent().clearBuffer();
        return this;
    }

    @Override
    public StringBuffer getBuffer() {
        return this.getParent().getBuffer();
    }

    @Override
    public IBoxContext pushBuffer(StringBuffer buffer) {
        this.getParent().pushBuffer(buffer);
        return this;
    }

    @Override
    public IBoxContext popBuffer() {
        this.getParent().popBuffer();
        return this;
    }

    @Override
    public Object invokeFunction(Key name, Object[] positionalArguments) {
        return this.getParent().invokeFunction(name, positionalArguments);
    }

    @Override
    public Object invokeFunction(Key name, Map<Key, Object> namedArguments) {
        return this.getParent().invokeFunction(name, namedArguments);
    }

    @Override
    public Object invokeFunction(Key name) {
        return this.getParent().invokeFunction(name);
    }

    @Override
    public Object invokeFunction(Object function, Object[] positionalArguments) {
        return this.getParent().invokeFunction(function, positionalArguments);
    }

    @Override
    public Object invokeFunction(Object function, Map<Key, Object> namedArguments) {
        return this.getParent().invokeFunction(function, namedArguments);
    }

    @Override
    public Object invokeFunction(Object function) {
        return this.getParent().invokeFunction(function);
    }

    @Override
    public Component.BodyResult invokeComponent(Key name, IStruct attributes, Component.ComponentBody componentBody) {
        return this.getParent().invokeComponent(name, attributes, componentBody);
    }

    @Override
    public IBoxContext pushComponent(IStruct executionState) {
        return this.getParent().pushComponent(executionState);
    }

    @Override
    public IBoxContext popComponent() {
        return this.getParent().popComponent();
    }

    @Override
    public IStruct[] getComponents() {
        return this.getParent().getComponents();
    }

    @Override
    public IStruct findClosestComponent(Key name) {
        return this.getParent().findClosestComponent(name);
    }

    @Override
    public IStruct findClosestComponent(Key name, Predicate<IStruct> predicate) {
        return this.getParent().findClosestComponent(name, predicate);
    }
}

