/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.context;

import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.statement.BoxMethodDeclarationModifier;
import ortus.boxlang.runtime.bifs.BIFDescriptor;
import ortus.boxlang.runtime.context.BaseBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.StaticScope;
import ortus.boxlang.runtime.scopes.ThisScope;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.UDF;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;
import ortus.boxlang.runtime.types.meta.BoxMeta;
import ortus.boxlang.runtime.util.ArgumentUtil;

public class ClassBoxContext
extends BaseBoxContext {
    protected IScope variablesScope;
    protected IScope thisScope;
    protected IScope staticScope;
    protected IClassRunnable thisClass;

    public ClassBoxContext(IBoxContext parent, IClassRunnable thisClass) {
        super(parent);
        this.variablesScope = thisClass.getVariablesScope();
        this.thisScope = thisClass.getThisScope();
        this.staticScope = thisClass.getStaticScope();
        this.thisClass = thisClass;
        if (parent == null) {
            throw new BoxRuntimeException("Parent context cannot be null for ClassBoxContext");
        }
    }

    @Override
    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (this.hasParent().booleanValue() && !shallow) {
            this.getParent().getVisibleScopes(scopes, false, false);
        }
        if (nearby) {
            scopes.getAsStruct(Key.contextual).put(ThisScope.name, (Object)this.thisScope);
            scopes.getAsStruct(Key.contextual).put(VariablesScope.name, (Object)this.variablesScope);
            scopes.getAsStruct(Key.contextual).put(StaticScope.name, (Object)this.staticScope);
        }
        return scopes;
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope, boolean shallow) {
        IBoxContext.ScopeSearchResult thisSerach = this.scopeFindThis(key);
        if (thisSerach != null) {
            return thisSerach;
        }
        if (key.equals(StaticScope.name)) {
            return new IBoxContext.ScopeSearchResult(this.staticScope, this.staticScope, key, true);
        }
        IBoxContext.ScopeSearchResult superSearch = this.scopeFindSuper(key);
        if (superSearch != null) {
            return superSearch;
        }
        if (key.equals(BoxMeta.key)) {
            return new IBoxContext.ScopeSearchResult(this.getThisClass(), this.getThisClass().getBoxMeta(), BoxMeta.key, false);
        }
        IBoxContext.ScopeSearchResult querySearch = this.queryFindNearby(key);
        if (querySearch != null) {
            return querySearch;
        }
        Object result = this.variablesScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.variablesScope, Struct.unWrapNull(result), key);
        }
        if (shallow) {
            return null;
        }
        return this.parent.scopeFind(key, defaultScope);
    }

    protected IBoxContext.ScopeSearchResult scopeFindThis(Key key) {
        if (key.equals(this.thisScope.getName())) {
            return new IBoxContext.ScopeSearchResult(this.getThisClass(), this.getThisClass(), key, true);
        }
        return null;
    }

    protected IBoxContext.ScopeSearchResult scopeFindSuper(Key key) {
        if (key.equals(Key._super)) {
            if (this.getThisClass().getSuper() != null) {
                return new IBoxContext.ScopeSearchResult(this.getThisClass().getSuper(), this.getThisClass().getSuper(), key, true);
            }
            if (this.getThisClass().isJavaExtends()) {
                DynamicObject jSuper = DynamicObject.of(this.getThisClass()).setTargetClass(this.getThisClass().getClass().getSuperclass());
                return new IBoxContext.ScopeSearchResult(jSuper, jSuper, key, true);
            }
        }
        return null;
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFind(Key key, IScope defaultScope) {
        return this.parent.scopeFind(key, defaultScope);
    }

    @Override
    public IScope getScope(Key name) throws ScopeNotFoundException {
        return this.parent.getScope(name);
    }

    @Override
    public IScope getScopeNearby(Key name, boolean shallow) throws ScopeNotFoundException {
        if (name.equals(this.variablesScope.getName())) {
            return this.variablesScope;
        }
        if (name.equals(StaticScope.name)) {
            return this.staticScope;
        }
        if (shallow) {
            return null;
        }
        return this.parent.getScope(name);
    }

    @Override
    public IScope getDefaultAssignmentScope() {
        return this.variablesScope;
    }

    @Override
    public IBoxContext getFunctionParentContext() {
        return this;
    }

    @Override
    public IClassRunnable getFunctionClass() {
        return this.thisClass;
    }

    @Override
    public void registerUDF(UDF udf, boolean override) {
        if (udf.hasModifier(BoxMethodDeclarationModifier.STATIC)) {
            this.registerUDF(this.staticScope, udf, override);
            return;
        }
        this.registerUDF(this.variablesScope, udf, override);
        if (udf.getAccess().isEffectivePublic()) {
            this.registerUDF(this.thisScope, udf, override);
        }
    }

    public IClassRunnable getThisClass() {
        return this.thisClass;
    }

    @Override
    public IBoxContext flushBuffer(boolean force) {
        if (!this.canOutput().booleanValue() && !force) {
            return this;
        }
        super.flushBuffer(force);
        return this;
    }

    @Override
    public Boolean canOutput() {
        return this.getThisClass().canOutput();
    }

    @Override
    public Object invokeFunction(Key name, Object[] positionalArguments) {
        BIFDescriptor bif = this.findBIF(name);
        if (bif != null) {
            return bif.invoke((IBoxContext)this, positionalArguments, false, name);
        }
        Function function = this.findFunction(name);
        if (function == null) {
            if (this.thisClass.getVariablesScope().containsKey(Key.onMissingMethod)) {
                return this.thisClass.getVariablesScope().dereferenceAndInvoke((IBoxContext)this, Key.onMissingMethod, new Object[]{name.getName(), ArgumentUtil.createArgumentsScope((IBoxContext)this, positionalArguments)}, (Boolean)false);
            }
            throw new BoxRuntimeException("Function [" + String.valueOf(name) + "] not found");
        }
        return this.invokeFunction(function, name, positionalArguments);
    }

    @Override
    public Object invokeFunction(Key name, Map<Key, Object> namedArguments) {
        BIFDescriptor bif = this.findBIF(name);
        if (bif != null) {
            return bif.invoke((IBoxContext)this, namedArguments, false, name);
        }
        Function function = this.findFunction(name);
        if (function == null) {
            if (this.thisClass.getVariablesScope().containsKey(Key.onMissingMethod)) {
                HashMap<Key, Object> args = new HashMap<Key, Object>();
                args.put(Key.missingMethodName, name.getName());
                args.put(Key.missingMethodArguments, ArgumentUtil.createArgumentsScope((IBoxContext)this, namedArguments));
                return this.thisClass.getVariablesScope().dereferenceAndInvoke((IBoxContext)this, Key.onMissingMethod, args, (Boolean)false);
            }
            throw new BoxRuntimeException("Function [" + String.valueOf(name) + "] not found");
        }
        return this.invokeFunction(function, name, namedArguments);
    }

    @Override
    public Object invokeFunction(Key name) {
        BIFDescriptor bif = this.findBIF(name);
        if (bif != null) {
            return bif.invoke(this, false);
        }
        Function function = this.findFunction(name);
        if (function == null) {
            if (this.thisClass.getVariablesScope().containsKey(Key.onMissingMethod)) {
                return this.thisClass.getVariablesScope().dereferenceAndInvoke((IBoxContext)this, Key.onMissingMethod, new Object[]{name.getName(), ArgumentUtil.createArgumentsScope((IBoxContext)this, new Object[0])}, (Boolean)false);
            }
            throw new BoxRuntimeException("Function [" + String.valueOf(name) + "] not found");
        }
        return this.invokeFunction(function, name, new Object[0]);
    }

    public IScope getThisScope() {
        return this.thisScope;
    }
}

