/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.context;

import java.util.Map;
import ortus.boxlang.runtime.context.FunctionBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.LocalScope;
import ortus.boxlang.runtime.types.Closure;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;

public class ClosureBoxContext
extends FunctionBoxContext {
    public ClosureBoxContext(IBoxContext parent, Closure function) {
        this(parent, function, new ArgumentsScope());
    }

    public ClosureBoxContext(IBoxContext parent, Closure function, ArgumentsScope argumentsScope) {
        this(parent, function, function.getName(), argumentsScope);
    }

    public ClosureBoxContext(IBoxContext parent, Closure function, Key functionCalledName, ArgumentsScope argumentsScope) {
        super(parent, function, functionCalledName, argumentsScope);
        if (parent == null) {
            throw new BoxRuntimeException("Parent context cannot be null for ClosureBoxContext");
        }
    }

    public ClosureBoxContext(IBoxContext parent, Closure function, Key functionCalledName, Object[] positionalArguments) {
        super(parent, (Function)function, functionCalledName, positionalArguments, (IClassRunnable)null);
        if (parent == null) {
            throw new BoxRuntimeException("Parent context cannot be null for ClosureBoxContext");
        }
    }

    public ClosureBoxContext(IBoxContext parent, Closure function, Key functionCalledName, Map<Key, Object> namedArguments) {
        super(parent, (Function)function, functionCalledName, namedArguments, null);
        if (parent == null) {
            throw new BoxRuntimeException("Parent context cannot be null for ClosureBoxContext");
        }
    }

    @Override
    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (this.hasParent().booleanValue() && !shallow) {
            this.getParent().getVisibleScopes(scopes, false, false);
        }
        if (nearby) {
            scopes.getAsStruct(Key.contextual).put(ArgumentsScope.name, (Object)this.argumentsScope);
            scopes.getAsStruct(Key.contextual).put(LocalScope.name, (Object)this.localScope);
        }
        IStruct lexicalScopes = this.getFunction().getDeclaringContext().getVisibleScopes(Struct.linkedOf(Key.contextual, Struct.linkedOf(new Object[0]), Key.lexical, Struct.linkedOf(new Object[0])), true, true);
        scopes.getAsStruct(Key.lexical).putAll(lexicalScopes.getAsStruct(Key.lexical));
        scopes.getAsStruct(Key.lexical).put(this.findClosestFunctionName(), (Object)lexicalScopes.getAsStruct(Key.contextual));
        return scopes;
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope, boolean shallow) {
        if (key.equals(this.localScope.getName())) {
            return new IBoxContext.ScopeSearchResult(this.localScope, this.localScope, key, true);
        }
        if (key.equals(this.argumentsScope.getName())) {
            return new IBoxContext.ScopeSearchResult(this.argumentsScope, this.argumentsScope, key, true);
        }
        Object result = this.localScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.localScope, Struct.unWrapNull(result), key);
        }
        result = this.argumentsScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.argumentsScope, Struct.unWrapNull(result), key);
        }
        IBoxContext.ScopeSearchResult querySearch = this.queryFindNearby(key);
        if (querySearch != null) {
            return querySearch;
        }
        IBoxContext.ScopeSearchResult declaringContextResult = this.getFunction().getDeclaringContext().scopeFindNearby(key, defaultScope, true);
        if (declaringContextResult != null) {
            return declaringContextResult;
        }
        if (shallow) {
            return null;
        }
        return this.parent.scopeFind(key, defaultScope);
    }

    @Override
    public IScope getScopeNearby(Key name, boolean shallow) throws ScopeNotFoundException {
        if (name.equals(LocalScope.name)) {
            return this.localScope;
        }
        if (name.equals(ArgumentsScope.name)) {
            return this.argumentsScope;
        }
        IScope declaringContextResult = this.getFunction().getDeclaringContext().getScopeNearby(name, true);
        if (declaringContextResult != null) {
            return declaringContextResult;
        }
        if (shallow) {
            return null;
        }
        return this.parent.getScope(name);
    }

    @Override
    public Closure getFunction() {
        return (Closure)this.function;
    }

    @Override
    public Object invokeFunction(Function function, Key calledName, Object[] positionalArguments) {
        FunctionBoxContext fbc;
        IBoxContext iBoxContext;
        FunctionBoxContext functionContext = Function.generateFunctionContext(function, this.getFunctionParentContext(), calledName, positionalArguments, (iBoxContext = this.getFunction().getDeclaringContext()) instanceof FunctionBoxContext && (fbc = (FunctionBoxContext)iBoxContext).isInClass() ? fbc.getThisClass() : null, this.getFunctionInterface());
        return function.invoke(functionContext);
    }

    @Override
    public Object invokeFunction(Function function, Key calledName, Map<Key, Object> namedArguments) {
        FunctionBoxContext fbc;
        IBoxContext iBoxContext;
        FunctionBoxContext functionContext = Function.generateFunctionContext(function, this.getFunctionParentContext(), calledName, namedArguments, (iBoxContext = this.getFunction().getDeclaringContext()) instanceof FunctionBoxContext && (fbc = (FunctionBoxContext)iBoxContext).isInClass() ? fbc.getThisClass() : null, this.getFunctionInterface());
        return function.invoke(functionContext);
    }

    @Override
    public boolean isInClass() {
        FunctionBoxContext fbc;
        IBoxContext iBoxContext = this.getFunction().getDeclaringContext();
        return iBoxContext instanceof FunctionBoxContext && (fbc = (FunctionBoxContext)iBoxContext).isInClass();
    }

    @Override
    public IClassRunnable getThisClass() {
        IBoxContext iBoxContext = this.getFunction().getDeclaringContext();
        if (iBoxContext instanceof FunctionBoxContext) {
            FunctionBoxContext fbc = (FunctionBoxContext)iBoxContext;
            return fbc.getThisClass();
        }
        return null;
    }
}

