/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.context;

import ortus.boxlang.runtime.context.BaseBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.UDF;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;

public class ContainerBoxContext
extends BaseBoxContext {
    protected IScope variablesScope = new VariablesScope();

    public ContainerBoxContext(IBoxContext parent) {
        super(parent);
    }

    @Override
    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (this.hasParent().booleanValue() && !shallow) {
            this.getParent().getVisibleScopes(scopes, false, false);
        }
        if (nearby) {
            scopes.getAsStruct(Key.contextual).put(VariablesScope.name, (Object)this.variablesScope);
        }
        return scopes;
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope, boolean shallow) {
        IBoxContext.ScopeSearchResult querySearch = this.queryFindNearby(key);
        if (querySearch != null) {
            return querySearch;
        }
        Object result = this.variablesScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.variablesScope, Struct.unWrapNull(result), key);
        }
        if (shallow) {
            return null;
        }
        return this.scopeFind(key, defaultScope);
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFind(Key key, IScope defaultScope) {
        return this.parent.scopeFind(key, defaultScope);
    }

    @Override
    public IScope getScope(Key name) throws ScopeNotFoundException {
        return this.parent.getScope(name);
    }

    @Override
    public IScope getScopeNearby(Key name, boolean shallow) throws ScopeNotFoundException {
        if (name.equals(this.variablesScope.getName())) {
            return this.variablesScope;
        }
        if (shallow) {
            return null;
        }
        return this.getScope(name);
    }

    @Override
    public void registerUDF(UDF udf, boolean override) {
        this.registerUDF(this.variablesScope, udf, override);
    }

    @Override
    public IScope getDefaultAssignmentScope() {
        return this.variablesScope;
    }
}

