/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.context;

import ortus.boxlang.runtime.context.BaseBoxContext;
import ortus.boxlang.runtime.context.ClassBoxContext;
import ortus.boxlang.runtime.context.FunctionBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.ThisScope;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.UDF;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;

public class CustomTagBoxContext
extends BaseBoxContext {
    protected IScope variablesScope;
    protected IScope thisScope;
    private Key tagName;

    public CustomTagBoxContext(IBoxContext parent, Key tagName) {
        super(parent);
        FunctionBoxContext context;
        this.tagName = tagName;
        this.variablesScope = new VariablesScope();
        this.thisScope = null;
        if (parent instanceof FunctionBoxContext && (context = (FunctionBoxContext)parent).isInClass()) {
            this.thisScope = context.getThisClass().getThisScope();
        } else if (parent instanceof ClassBoxContext) {
            ClassBoxContext context2 = (ClassBoxContext)parent;
            this.thisScope = context2.getThisClass().getThisScope();
        }
    }

    @Override
    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (this.hasParent().booleanValue() && !shallow) {
            this.getParent().getVisibleScopes(scopes, false, false);
        }
        if (nearby) {
            scopes.getAsStruct(Key.contextual).put(VariablesScope.name, (Object)this.variablesScope);
            if (this.thisScope != null) {
                scopes.getAsStruct(Key.contextual).put(ThisScope.name, (Object)this.thisScope);
            }
        }
        return scopes;
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope, boolean shallow) {
        Object result = this.variablesScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.variablesScope, Struct.unWrapNull(result), key);
        }
        IBoxContext.ScopeSearchResult querySearch = this.queryFindNearby(key);
        if (querySearch != null) {
            return querySearch;
        }
        if (shallow) {
            return null;
        }
        return this.parent.scopeFind(key, defaultScope);
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFind(Key key, IScope defaultScope) {
        if (this.thisScope != null && key.equals(ThisScope.name)) {
            return new IBoxContext.ScopeSearchResult(this.thisScope, this.thisScope, key, true);
        }
        return this.parent.scopeFind(key, defaultScope);
    }

    @Override
    public IScope getScope(Key name) throws ScopeNotFoundException {
        return this.parent.getScope(name);
    }

    @Override
    public IScope getScopeNearby(Key name, boolean shallow) throws ScopeNotFoundException {
        if (name.equals(this.variablesScope.getName())) {
            return this.variablesScope;
        }
        if (this.thisScope != null && name.equals(ThisScope.name)) {
            return this.thisScope;
        }
        if (shallow) {
            return null;
        }
        return this.parent.getScope(name);
    }

    @Override
    public void registerUDF(UDF udf, boolean override) {
        this.registerUDF(this.variablesScope, udf, override);
    }

    @Override
    public IScope getDefaultAssignmentScope() {
        return this.variablesScope;
    }

    public Key getTagName() {
        return this.tagName;
    }
}

